// 3.5inch mcufriend tftlcd
// Learning infra Red Remote Ver2  24/4/2015
// Touch works, SD card works
// Arduino MEGA 2560
// P J Webb 4/2015
// Serial data speed is 115200
// Acknowledgements:
//***************************************************************************************************
//This sketch uses the UTFT library developed by Henning Karlsen under the creative commons licence.
//***************************************************************************************************
//Works with IDE version 1.0.6
//Fails miserably with later IDE versions. despite assurance by the IDE developers that all sketches will be OK.
//SD now works. modified SD2Card.h in Arduino Library SD\Utility as follows:
//define software SPI pins 53 - SS, 52 = Clock, 51= MOSI, 50 = MISO
//#else  // SOFTWARE_SPI
// define software SPI pins so Mega can use unmodified GPS Shield
///** SPI chip select pin */
//uint8_t const SD_CHIP_SELECT_PIN = 53;// **** was 10;
///** SPI Master Out Slave In pin */
//uint8_t const SPI_MOSI_PIN = 51;// **** was 11;
//** SPI Master In Slave Out pin */
//uint8_t const SPI_MISO_PIN = 50;// **** was 12;
//** SPI Clock pin */
//uint8_t const SPI_SCK_PIN = 52; // **** was 13;
//#endif  // SOFTWARE_SPI

//also change line: #define MEGA_SOFT_SPI 1 //was 0
//SD2Card.h is in Arduino library SD in utility folder
//
//May need to change this back to standard for uno for Uno

#include <UTFT.h>
#include <UTouch.h>
#include <SD.h>
#include <EEPROM.h>

unsigned int irTimeOut = 5000;//5000 milliseconds
unsigned int const pulseSamples =69;//was 96
unsigned long int pulses[pulseSamples][2];  // pair is high and low pulse 
String mode ="NIL";

//SD card definitions
Sd2Card card;
SdVolume volume;
SdFile root;
const int chipSelect = 53;    

//TFT LCD and Touch screen setup
UTFT    myGLCD(ILI9327_8,38,39,40,41);
UTouch  myTouch( 6, 5, 4, 3, 2);

int keyNum; //The number of the button pressed base 0.

//Fonts
extern uint8_t SmallFont[];
extern uint8_t BigFont[];


int deviceIndex = 0;  //eg TV, DVD etc
int oldDeviceIndex = 0;
int screenIndex = 0; // 0 is top screen 
int oldScreenIndex = 0;
int oldKeyNum = 99;//required to allow key 0 to operate initially

//labelDevice[] - this is the array for device text displayed at the screen bottom for the device selected.  
//The device selected button text can be different or the same as the definition in LabelDevice array.
// Increase or decrease this array to suit the number of devices required.
//The device selected total numbers in the screen button definitions must match this array size
//Remember: Arduino arrays are base 0 thus array[8] = 8 values with indexes of 0 to 7 
//Remember: = assigns, == compares (How crazy.  Surely the complier could be made smart enough to know that in the case that an "=" follows an "if" statement then it is a comparison not an assignment) 

char* labelDevice[7]  = {
  "TV", "DVD", "HDMI", "Apple TV", "PVRec", "Media", "Amp"};

unsigned int frame[32][4];//frame data memory - to compare against a touch X & Y coordinate

//Definitions for Slash menu item Types:  /Txx = Toggle Boolean, /Axx = Analysis,/Nxx = Numeric calculation, /Cxx = Control - xx is not used,  /Sxx = SubMenu - xx is the SubMenu to open, /Dxx = Device - xx is the device index required

char* menuData[32]={
}; //the menu label data array

//Macro functions to be Developed
//const int macroArrayLength = 5;  //
//String macro[macroArrayLength];//the macro array for recording
//int macroCounter; //index to macro array
//int currentMacro; //index to current Macro number

//Power off
unsigned long oldTime;
unsigned long offTime = 30; //seconds


//38kHz duty cycle
unsigned int dutyHigh = 6; //50% duty cycle
unsigned int dutyLow = 6;
unsigned int adjustModulationLength = 26; //period of 38kHz is 26.32us
unsigned int adjustPulseDuration = 100;//% increase or decrease in pulse length
unsigned int adjustPauseDuration = 100;//% increase or decrease in pulse pause
boolean roundUp = true;  //Flag for rounding of the pulse data to 600us for testing purposes

//setup default colour scheme
int textColor = VGA_WHITE;
int backColor = VGA_RED;
int frameColor = VGA_WHITE;
int frameHighlightColor =VGA_RED;
int screenBackColor = VGA_RED;

File myFile; 
//*************************************************
void setup()
{
  oldTime = millis();
  pinMode(8, INPUT); //IR receiver
  pinMode(9, OUTPUT);      // sets the digital pin as output
  digitalWrite (9, LOW); //IR LED
  pinMode(10,OUTPUT);  
  digitalWrite (10,LOW);  //Keeps power on
  pinMode (53,OUTPUT);
  digitalWrite (53,HIGH);  

  Serial.begin(115200);
  Serial.println("***********************************");  
  Serial.println ("Welcome to Phillip's IR Remote.");
  Serial.println ("  Please wait while I boot up.");
  Serial.println("***********************************");  
  myGLCD.InitLCD(PORTRAIT);
  myTouch.InitTouch();
  myTouch.setPrecision(PREC_MEDIUM);
  //setup SD card
  if (card.init(SPI_HALF_SPEED, chipSelect)) 
  {
    Serial.println ("In cardInfo.  SD card Initialised OK.");
  }
  else
  {
    Serial.println("In cardInfo. SD card initialization failed!");
  }
  //cardInfo(); //see what files are on the card if you want
  SD.begin (chipSelect);
  readEepromInitFile();  // read screen colours and settings
  myGLCD.fillScr(screenBackColor);
  myGLCD.setBackColor(backColor);
  myGLCD.setColor(textColor);
  //processScreenSetup();
}
//*************************************************
void loop()
{
  Serial.println();
  Serial.print ("In loop. screenIndex is: ");
  Serial.println (screenIndex);
  myGLCD.fillScr(screenBackColor);
  switch (screenIndex)
  {
  case 0: //Main Menu
    //drawMenu(int leftX, int topY, int cols, int rows, int width, int height,int colGap,int rowGap char* lbl[])
    menuData[0] = "Power",  menuData[1] = "/S02Input",  menuData[2] = "/S07CPanel",  menuData[3] = "/C00Prog",  menuData[4] = "/D00TV",  menuData[5] = "/D01DVD";
    menuData[6] = "/D02HDMI",  menuData[7] = "/D03Apple",  menuData[8] = "/D04PVR",  menuData[9] = "/D05Media",  menuData[10] = "/D06Amp";//
    menuData[11] = "/S010-9",  menuData[12] = "Vol +",  menuData[13] = "Mute",  menuData[14] = "Sleep",  menuData[15] = "CH +";
    menuData[16] = "Vol -",  menuData[17] = "Info",  menuData[18] = "",  menuData[19] = "CH -",  menuData[20] = "End";
    menuData[21] = "  UP",  menuData[22] = "Menu",  menuData[23] = "Play",  menuData[24] = " LEFT",  menuData[25] = "ENTER";
    menuData[26] = "RIGHT",  menuData[27] = "Stop",  menuData[28] = "Exit",  menuData[29] = " DOWN",  menuData[30] = "Tools";//
    menuData[31] = "/S10..More";
    drawMenu(5, 2, 4, 8, 56, 45,2,2,menuData,SmallFont);  //main menu
    processScreen (32,menuData);
    break;

  case 1: //Numbers Screen
    menuData[0] = "1",  menuData[1] = "2",  menuData[2] = "3",  menuData[3] = "4",  menuData[4] = "5",  menuData[5] = "6";
    menuData[6] = "7",  menuData[7] = "8",  menuData[8] = "9",  menuData[9] = "Spot",  menuData[10] = "0";//
    menuData[11] = "Ent",  menuData[12] = "/C00Prog",  menuData[13] = "-",  menuData[14] = "/S00Exit";
    drawMenu(5, 7, 3, 5, 72, 65,5,5,menuData, BigFont);
    processScreen(15,menuData);
    break;

  case 2: //Generic Input Selection
    menuData[0] = "In-1",  menuData[1] = "In-2",  menuData[2] = "In-3",  menuData[3] = "In-4",  menuData[4] = "In-5",  menuData[5] = "IN-6";
    menuData[6] = "In-7",  menuData[7] = "In-8",  menuData[8] = "In-9",  menuData[9] = "-",  menuData[10] = "/C00Prog",  menuData[11] = "/S00Exit";
    screenIndex = 2;//subMenuToCall;
    drawMenu(5, 7, 3, 4, 72, 65,5,5,menuData, BigFont);
    processScreen(12,menuData);
    break;


  case 3: //Settings
    //drawMenu(int leftX, int topY, int cols, int rows, int width, int height,int colGap,int rowGap, char* lbl[])
    processSettingsScreen();
    //delay (5000);
    break;

  case 4: //Screen Setup
    processScreenSetup();
    /*
  case  5:  //Keyboard future
     menuData[0] = "1",  menuData[1] = "2",  menuData[2] = "3",  menuData[3] = "4",  menuData[4] = "5",  menuData[5] = "6";
     menuData[6] = "7",  menuData[7] = "7",  menuData[8] = "9",  menuData[9] = "0",  menuData[10] = "A";//
     menuData[11] = "B",  menuData[12] = "C",  menuData[13] = "D",  menuData[14] = "E",  menuData[15] = "F";
     menuData[16] = "G",  menuData[17] = "H",  menuData[18] = "I",  menuData[19] = "J",  menuData[20] = "K";
     menuData[21] = "L",  menuData[22] = "M",  menuData[23] = "N",  menuData[24] = "O",  menuData[25] = "P";
     menuData[26] = "Q",  menuData[27] = "R",  menuData[28] = "S",  menuData[29] = "T",  menuData[30] = "U";
     menuData[31] = "V",  menuData[32] = "W",  menuData[33] = "X",  menuData[34] = "Y",  menuData[35] = "Z";
     menuData[36] = ".",  menuData[37] = "Space",  menuData[38] = " ",  menuData[39] = " ",  menuData[40] = "/S0E";
     menuData[31] = "Pause";
     drawMenu(5, 7, 5, 8, 40, 35,5,menuData, SmallFont);
     processScreen(40,menuData);
     break;
     */
    /*
  case  6:  //Macro Future
     menuData[0] = "/M01Macro 1",  menuData[1] = "/M01Macro 1",  menuData[2] = "/M01Macro 1",  menuData[3] = "/M01Macro 1",  menuData[4] = "/M01Macro 1",  menuData[5] = "/M01Macro 1";
     menuData[6] = "/C01Record",  menuData[7] = "/S00Exit";
     drawMenu(5, 7, 1, 8, 75, 40,5,menuData, SmallFont);
     processScreen(8,menuData);
     break;
     */
  case  7:  //control panel

    menuData[0] = "/S08Colour",  menuData[1] = "/S14Custom IR",  menuData[2] = "/S09IR Setup",  menuData[3] = "",  menuData[4] = "/A00IR Data",  menuData[5] = "";
    menuData[6] = "/S11IR Protocol",  menuData[7] = "",  menuData[8] = "/S03Settings",  menuData[9] = "/S04Screen Setup",  menuData[10] = "/C00Prog",  menuData[11] = "/S00Exit";
    drawMenu(5, 7, 2, 6, 110, 50,5,5,menuData, SmallFont);
    processScreen(12,menuData);
    break;


  case 8: //colours
    menuData[0] =  "R+",menuData[1] =  "G+",menuData[2] =  "B+",menuData[3] =  "R-",menuData[4] =  "G-",menuData[5] =  "B-";
    menuData[6] =  "Screen",menuData[7] =  "Backgrnd",menuData[8] =  "Text",menuData[9] =  "Border",menuData[10] =  "HiLight",menuData[11] =  "/S07Exit"; //colours
    selectColors();    
    break;



  case 9: //IR Setup
    menuData[0] =  "/C00Prog",menuData[1] =  "IRTest",menuData[2] =  "/N00DC Hi+",menuData[3] =  "/N01DC Hi-",menuData[4] =  "/N02DC Lo+";
    menuData[5] =  "/N03DC Lo-",menuData[6] =  "/N04PW +",menuData[7] =  "/N05PW -",menuData[8] ="/N06Dur %+", menuData[9] = "/N07Dur %-";
    menuData[10] =  "/N08Gap %+",menuData[11] =  "/N09Gap %-";
    menuData[12] =  "Reset",menuData[13] = "/N10Save";
    menuData[14] =  "";
    menuData[15] =  "/S07Exit";
    drawMenu(5, 7, 2, 8, 105, 35,5,5,menuData, BigFont);
    processScreen(16,menuData);
    break;
  case 10: //Extra Control functions
    menuData[0] = "  <-.",  menuData[1] = "  .->",  menuData[2] = "Play";
    menuData[3] = "  |<-",  menuData[4] = "  ->|",  menuData[5] = "Stop";
    menuData[6] = "  <<<-",  menuData[7] = " ->>>",  menuData[8] = "Pause";
    menuData[9] = "Menu",  menuData[10] = "List",    menuData[11] = "Guide";
    menuData[12] = "Record",  menuData[13] = "  UP",  menuData[14] = "Rec Stop";
    menuData[15] = " LEFT",    menuData[16] = " ENTER",  menuData[17] = " RIGHT";
    menuData[18] = "Exit",  menuData[19] = " DOWN",    menuData[20] = "Display";
    menuData[21] = "/C00Prog",    menuData[22] = "Eject",  menuData[23] = "/S00Exit";//  
    drawMenu(5, 7, 3, 8, 70, 40,5,5,menuData, SmallFont);
    processScreen(24,menuData);
    break;
  case 11://Protocol
    showProtocol();
    //delay (5000);
    break;    
  case 12: //TV Input
    menuData[0] = "In1 CSAV",  menuData[1] = "In2 CSAV",  menuData[2] = "In3 SAVH",  menuData[3] = "In4 HDMI",  menuData[4] = "In5 SAV",  menuData[5] = "IN6 PC";
    menuData[6] = "In7 TV/D",  menuData[7] = "",  menuData[8] = "Select",  menuData[9] = "-",  menuData[10] = "/C00Prog",  menuData[11] = "/S00Exit";
    screenIndex = 12;//subMenuToCall;
    drawMenu(5, 7, 3, 4, 72, 65,5,5,menuData, SmallFont);
    processScreen(12,menuData);
    break;
  case 13: //Amp Input
    menuData[0] = "Video 1",  menuData[1] = "Video 2",  menuData[2] = "Video 3",  menuData[3] = "DVD",  menuData[4] = "TV/SAT",  menuData[5] = "MD/Tape";
    menuData[6] = "CD",  menuData[7] = "Tuner",  menuData[8] = "Phono",  menuData[9] = "Aux",  menuData[10] = "/C00Prog",  menuData[11] = "/S00Exit";
    screenIndex = 13;//subMenuToCall;
    drawMenu(5, 7, 3, 4, 72, 65,5,5,menuData, SmallFont);
    processScreen(12,menuData);
    break;
  case 14://Custom Codes
    showCustom();
    break;
  default:
    screenIndex = 0;
  }
}
//*********************************************************
void processScreenSetup()
//This function checks the x,y coordinate system
{

  myGLCD.clrScr();
  //textColor = VGA_WHITE;
  myGLCD.setFont(SmallFont); 
  //myGLCD.fillScr(VGA_BLUE);
  //myGLCD.setBackColor(VGA_RED);
  //myGLCD.setColor(VGA_WHITE);
  //myGLCD.fillCircle(100,100,25);
  int x;
  int y;
  int fromLowX = 295;
  int fromHighX =0;
  int  toLowX =0;
  int toHighX = 220;
  int fromLowY =235;
  int fromHighY =0; 
  int toLowY =0;
  int toHighY =390;


  myGLCD.print ("Tap screen:", 50,100);  
  keyNum =99;
  do
  {
    if (myTouch.dataAvailable())
    {
      for (int i = 0 ;i <5; i++)
      {
        myTouch.read();  //get a number of samples
      }
      //this is where you must calibrate the TFT touch screen to correspond to the screen button x,y
      /*For Landscape
       y = myTouch.getX() ;
       y = map(y,0,320,240,0);
       //Serial.print ("Y");
       //Serial.println (y);
       x = myTouch.getY();
       x= map(x,0,240,0,400);
       ` //Serial.print ("X");
       //Serial.println (x);
       */
      //For Portrait
      x = myTouch.getX() ;
      y = myTouch.getY();
      //myGLCD.fillCircle(x,y,2);
      Serial.print (x);
      Serial.print ("/");
      Serial.println  (y);
      //myGLCD.fillCircle(x +10,y+10,2);
      myGLCD.drawRect(20,20,220,380);

      myGLCD.print ("+", 20,20);
      myGLCD.print ("20,20", 40,40);

      myGLCD.print ("+", 220,20);
      myGLCD.print ("220,20", 140,40);

      myGLCD.print ("+",20 ,380);
      myGLCD.print ("20,380",40 ,360);

      myGLCD.print ("+", 220,380);
      myGLCD.print ("220,380", 140,360);
      //textColor = VGA_WHITE;
      //      


      myGLCD.print ("Raw X/Y", 50,150);
      myGLCD.print ("   ", 120,150);
      myGLCD.print (String(x), 120,150);
      myGLCD.print ("   ", 150,150);
      myGLCD.print (String(y), 150,150);

      //x = myTouch.getX() ;
      x = map(x, fromLowX,fromHighX,toLowX,toHighX);
      //x = map(x,295,0,0,220);//change this for different screens
      //Serial.print ("X");
      //Serial.println (x);
      //y = myTouch.getY();
      y = map(y, fromLowY,fromHighY,toLowY,toHighY);
      //y= map(y,235,0,0,390);//change this for different screens
      //x = map(x,215,0,0,215);//change this for different screens
      //Serial.print ("X");
      //Serial.println (x);

      //y= map(y,320,0,0,320);//change this for different screens
      //Serial.print ("Y");
      //Serial.println (y);
      //constrain (x,0,220); //Another Arduino function that doesn't work properly!!! still gives negative x values.
      if (x<0)
      {        
        x =0;      
      }
      if (y<0)
      {        
        y =0;      
      }
      //constrain (y,0,400);

      myGLCD.print ("Adj X/Y", 50,180);
      myGLCD.print ("   ", 120,180);
      myGLCD.print (String(x), 120,180);
      myGLCD.print ("   ", 150,180);
      myGLCD.print (String(y), 150,180);

      myGLCD.print ("X Size", 50,220);
      myGLCD.print ("   ", 130,220);
      myGLCD.print (String(myGLCD.getDisplayXSize()), 130,220);
      myGLCD.print ("Y Size", 50,240);
      myGLCD.print ("   ", 130, 240);
      myGLCD.print (String(myGLCD.getDisplayYSize()), 130,240);
      delay(250);

      if (x >60 and x <140)
      {
        if (y >100 and y <180)
        {
          myGLCD.clrScr();
          return;
        }
      }
      //CHECK SCREEN AGAINST FRAME DATA
      /*
    for (int z = 0; z<32; z++)
       {
       if ((x > frame [z][0] && x <frame[z][2]) && (y > frame [z][1] && y <frame[z][3]))
       {
       //touch found
       drawFrame(frame [z][0],frame [z][1],frame [z][2],frame [z][3],z);    
       keyNum = z;
       //Serial.println();
       // 
       if (keyNum <99)
       {
       Serial.print("In getKey.  keyNum =: ");
       Serial.println (keyNum);
       }
       exit;
       }
       
       
       }
       */
    }
  } 
  while (keyNum >1);
}
//********************************************************************
void executeScanProtocol(String protocol,int protocolNum, int address, int command)
{
  printProtocolAddressCommand(protocol, address,command );//show the sleection at the screen foot.
  sendProtocol (protocolNum,address,command); //prepares the protocol pulse data array ready for ttransmission
  transmitIr(); //transmits the pulses data array
  delay(250);

}
//*******************************************************************
void printProtocolAddressCommand(String protocol, int address, int command)
//Prints the selected protocol details at the foot of the screen
{
  myGLCD.setColor(textColor);
  myGLCD.print ("Pro: ",10,380);
  myGLCD.print ("        ",45,380);
  myGLCD.print (protocol,45,380);
  myGLCD.print ("Add: ",110,380);
  myGLCD.print ("   ",140,380);
  myGLCD.print (String(address),140,380);
  myGLCD.print ("Cmd: ",175,380);
  myGLCD.print ("   ",205,380);
  myGLCD.print (String(command),205,380);

}
//********************************************************************
void showCustom()
{
  myGLCD.clrScr();
  myGLCD.setColor(textColor);
  myGLCD.setFont(SmallFont);
  //drawMenu(int leftX, int topY, int cols, int rows, int width, int height,int colGap,int rowGap char* lbl[])
  menuData[0] = "0",  menuData[1] = "1",  menuData[2] = "2",  menuData[3] = "3";
  menuData[4] = "4",  menuData[5] = "5",    menuData[6] = "6",  menuData[7] = "7";
  menuData[8] = "8",  menuData[9] = "9",  menuData[10] = "Pionee",    menuData[11] = "Panaso";
  menuData[12] = "SIRC12",  menuData[13] = "SIRC15",  menuData[14] = "SIRC20",  menuData[15] = "NEC";
  menuData[16] = "Adr +1",  menuData[17] = "Cmd +1",  menuData[18] = "Sharp",  menuData[19] = "Sams32";
  menuData[20] = "Adr -1",    menuData[21] = "Cmd -1",  menuData[22] = "Sams38",  menuData[23] = "Daewoo";
  menuData[24] = "ScnAdr",  menuData[25] = "ScnCmd",    menuData[26] = "Stop",  menuData[27] = "xRC5";
  menuData[28] = "Adr:",  menuData[29] = "Cmd:",  menuData[30] = "SendIR",    menuData[31] = "Exit";
  drawMenu(5, 2, 4, 8, 56, 45,2,2,menuData,SmallFont);  //main menu
  //was do here
  myGLCD.setColor(textColor);

  //Calculate command  and address
  String protocol ="";
  int protocolNum = 0;
  int address =0;
  int command = 0;
  int scanStart;
  String mode = "Protocol";  
  String temp = "";

  do
  {

    //Serial.print ("Address= ");
    //Serial.println (deviceAddress);
    //Serial.print ("Command= ");
    //Serial.println (deviceCommand);
    printProtocolAddressCommand(protocol, address,command);
    do
    { 
      getKey();
      //Serial.print ("In showCustom.  Key num is: ");
      //Serial.println (keyNum);
      if (keyNum <10) //0 to 9 
      {
        temp = temp + String (keyNum);
        if (temp.toInt() >256)
        {
          temp ="";
        }

        if (mode == "Address")
        {
          address = temp.toInt();
        }  
        if (mode == "Command")
        {
          command = temp.toInt();
        }  
      }
      if ((keyNum >9 and keyNum < 16) or (keyNum == 18) or (keyNum==19) or(keyNum == 22) or (keyNum ==23)or (keyNum ==27) ) //Protocols
      {
        protocol = menuData [keyNum];
        mode = "Protocol";
        protocolNum = keyNum; //Pioneer =10, SIRC12 =12 , SIRC12 = 13, SIRC20 = 14, NEC = 15, Sharp = 18, Samsung32 = 19, samsumg38 =22, Daewoo = 23, RC5 = 27
        temp ="";
      }

      switch (keyNum)
      {
      case 16://a+1
        if (address <255)
        {
          address = address +1;
          executeScanProtocol(protocol, protocolNum,address,command)  ;           
        }
        break;
      case 20://a-1
        if (address >0)
        {
          address = address -1;
          executeScanProtocol(protocol,protocolNum, address,command)  ;            

        }
        break;
      case 17://c+1
        if (command <255)
        {
          command = command +1;
          executeScanProtocol(protocol, protocolNum,address,command) ;             
        }
        break;
      case 21://c-1
        if (command >0)
        {
          command = command -1;
          executeScanProtocol(protocol,  protocolNum,address,command) ;             
        }
        break;

      case 24://Scan Address
        mode ="Scan Address";
        scanStart = address;
        for (int i = scanStart; i<256;i++)
        {
          address = i;
          getKey();
          if (keyNum ==26)//Stop
          {
            break;
          }
          if (protocol=="")
          {
          }
          else
          {
            executeScanProtocol(protocol, protocolNum, address,command)  ;            
          }
        }
        temp="";
        break;
      case 25://Scan Cmd
        mode ="Scan Command";
        scanStart = command;
        for (int i = scanStart; i<256;i++)
        {
          command = i;
          getKey();
          if (keyNum ==26)//Stop
          {
            break;
          }
          if (protocol=="")
          {
          }
          else
          {
            executeScanProtocol(protocol,  protocolNum,address,command);
          }
        }
        temp="";
        break;
      case 28://Dev
        mode = "Address";
        temp ="";
        break;
      case 29://Cmd
        mode = "Command";
        temp ="";
        break;
      case 30://send IR
        executeScanProtocol(protocol,  protocolNum,address,command);
        break;
      case 31://exit
        screenIndex = 7;
        break;
      }
    }  
    while (keyNum >31);
    //Serial.print ("In showData.  showIndex = ");
    //Serial.println (showIndex);
    // }while (keyNum <=99);


  }  
  while (keyNum < 31);//exit if keynum == 31
  Serial.print ("In showCustom.  Exiting function");
  screenIndex = 7;
}


//***********************************************
int ipow(int base, int exp)
{
  int result = 1;
  while (exp)
  {
    if (exp & 1)
      result *= base;
    exp >>= 1;
    base *= base;
  }

  return result;
}
//***********************************************************
void sendProtocol (int protocol,int address,int command)
{
  //pulses [i][0] is pause
  //pulses [i][1] is pulse
  //first reset all pulse dats
  for (int i = 0 ; i<pulseSamples; i++)
  {
    pulses[i][0]=0;
    pulses[i][1]=0;
  }

  if (protocol >=12 and protocol <=14)
  {  
    sendSIRC(protocol,address,command);
  }
  if (protocol ==15)//NEC
  {  
    sendNECx(address,command);
  }
  /*if (protocol ==16)
   {  sendSharp(protocol,address,command);}
   
   */
  if (protocol ==10)//Pioneer
  {
    sendPion(address,command);  
  }
  if (protocol ==11)
  {
    sendPana(address,command);
  }
  if (protocol ==18)
  {  
    sendSharp(address,command);
  }
  if (protocol ==19)
  {  
    sendSamsung32(address,command);
  }
  if (protocol ==22)
  {  
    sendSamsung38(address,command);
  }
  if (protocol ==23)
  {  
    sendDaewoo(address,command);
  }
  if (protocol ==27)
  {  
    sendRC5X(address,command);
  }

  //Add others here

}
//*************************************************
void sendRC5X(int address, int command)//future
{

}

//*************************************************
void sendSharp(int address, int command)
{
  int power = 0;
  int c= 0;
  int x= 0;
  unsigned long int temp =0;
  //No header 
  //Byte 0  Address  
  for (int i = 0 ;i<5;i++)
  {
    power =ipow(2,i);
    c= (address & power)/power;
    if (c ==    1) 
    {
      pulses[i][1] =320;
      pulses[i][0] =1680;
    } 
    else
    {
      pulses[i][1] =320;
      pulses[i][0] =680;
    }
  }
  //Byte 1 Command 
  //Serial.print ("Sharp ");
  //  Serial.print (command);

  for (int i = 5 ;i<13;i++)
  {
    power =ipow(2,i-5);
    c= (command & power)/power;
    if (c ==    1) 
    {
      pulses[i][1] =320;
      pulses[i][0] =1680;
    } 
    else
    {
      pulses[i][1] =320;
      pulses[i][0] =680;
    }
  }
  // Expansion 1 bit make it zero
  pulses[13][1] =320;
  pulses[13][0] =680;
  // Check  1 bit make it zero
  pulses[14][1] =320;
  pulses[14][0] =680;
  //last bit
  pulses[15][1] =320;
  pulses[15][0] =40000; //40ms pause between 
  //duplicate
  for (int i = 0; i<16;i++) //duplicate 4 lots
  {
    pulses [i +16][1] = pulses [i][1];
    pulses [i+16][0] = pulses [i][0];
    pulses [i +32][1] = pulses [i][1];
    pulses [i+32][0] = pulses [i][0];
    pulses [i +48][1] = pulses [i][1];
    pulses [i+48][0] = pulses [i][0];
  }
  //now invert commands, Exp and chk

  for (int i = 5; i<15;i++)
  {
    if ( pulses [i][0] == 1680 ) //invert
    {
      pulses [i +16][0] = 680 ;
      pulses [i +48][0] = 680;
    }
    else
    {
      pulses [i +16][0] = 1680;
      pulses [i +48][0] = 1680;
    }


  }

}

//*************************************************
void sendSamsung38(int address, int command)
{
  int power = 0;
  int c= 0;
  int x= 0;
  unsigned long int temp =0;
  //header first
  pulses [0][1] = 4500;
  pulses [0][0] = 4500;
  // 1 = 590 1690
  // 0 = 590 590\
  // stop 590 590 

    //Byte 1 custom code
  for (int i = 1 ;i<9;i++)
  {
    power =ipow(2,i-1);
    c= (address & power)/power;
    if (c ==    1) 
    {
      pulses[i][1] =590;
      pulses[i][0] =1690;
    } 
    else
    {
      pulses[i][1] =590;
      pulses[i][0] =590;
    }
  }
  //Byte 2 custom code
  for (int i = 9 ;i<17;i++)
  {
    power =ipow(2,i-9);
    c= (address & power)/power;
    if (c ==    1) 
    {
      pulses[i][1] =590;
      pulses[i][0] =1690;
    } 
    else
    {
      pulses[i][1] =590;
      pulses[i][0] =590;
    }
  }
  //Bit 17
  pulses[17][1] =590;
  pulses[17][0] =4500;
  //byte 3 ' 4 bit sseems to be always 1110
  pulses[18][1] =590;
  pulses[18][0] =1690;
  pulses[19][1] =590;
  pulses[19][0] =1690;
  pulses[20][1] =590;
  pulses[20][0] =1690;
  pulses[21][1] =590;
  pulses[21][0] =590;

  //Byte 4 command
  for (int i = 22 ;i<30;i++)
  {
    power =ipow(2,i-22);
    c= (command & power)/power;
    if (c ==    1) 
    {
      pulses[i][1] =590;
      pulses[i][0] =1690;
    } 
    else
    {
      pulses[i][1] =590;
      pulses[i][0] =590;
    }
  }

  //Byte 5  inverse of command
  for (int i = 30 ;i<37;i++)
  {
    power =ipow(2,i-30);
    c= (command & power)/power;
    if (c ==    1) 
    {
      pulses[i][1] =590;
      pulses[i][0] =590;
    } 
    else
    {
      pulses[i][1] =590;
      pulses[i][0] =1690;
    }
  }

  //finish off
  pulses [38][1] = 590;
  temp = 0;
  for (int i = 0 ;i <38;i++)
  {
    temp = pulses [i][0] + pulses [i][1] + 590;
  }

  pulses [38][0] = 60000 - temp; //this is approximate. need to find the message length and calculate this pause!

  //duplicate
  for (int i = 0; i<39;i++)
  {
    if ( (i +39) < pulseSamples-1)
    {
      pulses [i +39][1] = pulses [i][1];
      pulses [i+39][0] = pulses [i][0];
    }
  }

}

//*************************************************
void sendSamsung32(int address, int command)
{
  int power = 0;
  int c= 0;
  int x= 0;
  unsigned long int temp =0;
  //header first
  pulses [0][1] = 4500;
  pulses [0][0] = 4500;
  // 1 = 590 1690
  // 0 = 590 590\
  // stop 590 590 

    //Byte 1 custom code
  for (int i = 1 ;i<9;i++)
  {
    power =ipow(2,i-1);
    c= (address & power)/power;
    if (c ==    1) 
    {
      pulses[i][1] =590;
      pulses[i][0] =1690;
    } 
    else
    {
      pulses[i][1] =590;
      pulses[i][0] =590;
    }
  }
  //Byte 2 custom code
  for (int i = 9 ;i<17;i++)
  {
    power =ipow(2,i-9);
    c= (address & power)/power;
    if (c ==    1) 
    {
      pulses[i][1] =590;
      pulses[i][0] =1690;
    } 
    else
    {
      pulses[i][1] =590;
      pulses[i][0] =590;
    }
  }

  //Byte 3 command
  for (int i = 17 ;i<25;i++)
  {
    power =ipow(2,i-17);
    c= (command & power)/power;
    if (c ==    1) 
    {
      pulses[i][1] =590;
      pulses[i][0] =1690;
    } 
    else
    {
      pulses[i][1] =590;
      pulses[i][0] =590;
    }
  }

  //Byte 4  inverse of command
  for (int i = 25 ;i<33;i++)
  {
    power =ipow(2,i-25);
    c= (command & power)/power;
    if (c ==    1) 
    {
      pulses[i][1] =590;
      pulses[i][0] =590;
    } 
    else
    {
      pulses[i][1] =590;
      pulses[i][0] =1690;
    }
  }

  //finish off
  pulses [33][1] = 590;
  temp = 0;
  for (int i = 0 ;i <33;i++)
  {
    temp = pulses [i][0] + pulses [i][1] + 590;
  }

  pulses [33][0] = 60000 - temp; //this is approximate. need to find the message length and calculate this pause!

  //duplicate
  for (int i = 0; i<34;i++)
  {
    if ( (i +34) < pulseSamples-1)
    {
      pulses [i +34][1] = pulses [i][1];
      pulses [i+34][0] = pulses [i][0];
    }
  }

}

//*************************************************
void sendPana(int address, int command)
{
  int power = 0;
  int c= 0;
  int x= 0;
  unsigned long int temp =0;
  //header first
  pulses [0][1] = 3500;
  pulses [0][0] = 1700;

  //Byte 1 always 2
  for (int i = 1 ;i<9;i++)
  {
    pulses[i][1] =435;
    pulses[i][0] =435;
  }
  pulses[2][0] = 1300;

  //Byte 2 always 32
  for (int i = 9 ;i<17;i++)
  {
    pulses[i][1] =435;
    pulses[i][0] =435;
  }
  pulses[14][0] = 1300;

  //Byte 3  Address  
  for (int i = 17 ;i<25;i++)
  {
    power =ipow(2,i-17);
    c= (address & power)/power;
    if (c ==    1) 
    {
      pulses[i][1] =435;
      pulses[i][0] =1300;
    } 
    else
    {
      pulses[i][1] =435;
      pulses[i][0] =435;
    }
  }
  //Byte 4 SubAddress  - all zero
  for (int i = 25 ;i<33;i++)
  {
    pulses[i][1] =435;
    pulses[i][0] =435;
  }

  //Byte 5 command
  for (int i = 33 ;i<41;i++)
  {
    power =ipow(2,i-33);
    c= (command & power)/power;
    if (c ==    1) 
    {
      pulses[i][1] =435;
      pulses[i][0] =1300;
    } 
    else
    {
      pulses[i][1] =435;
      pulses[i][0] =435;
    }
  }
  //Byte 6 and Xor of bytes 3,4 &5
  x = (address ^ 0); //xor of bytes - sub address = 0
  x = x ^ command;
  for (int i = 41 ;i<49;i++)
  {
    power =ipow(2,i-41);
    c= (x & power)/power;
    if (c ==    1)
    {
      pulses[i][1] =435;
      pulses[i][0] =1300;
    } 
    else
    {
      pulses[i][1] =435;
      pulses[i][0] =435;
    }
  }


  //finish off
  pulses [49][1] = 435;
  pulses [49][0] = 74000; //this is approximate. need to find the message length and calculate this pause!

  //duplicate
  for (int i = 0; i<50;i++)
  {
    if ( (i +50) < pulseSamples-1)
    {
      pulses [i +50][1] = pulses [i][1];
      pulses [i+50][0] = pulses [i][0];
    }
  }

}
//*************************************************
void sendPion(int address, int command)
{
  int power = 0;
  int c= 0;
  unsigned long int temp =0;
  //header first
  pulses [0][1] = 8000;
  pulses [0][0] = 4000;
  //Address first
  for (int i = 1 ;i<9;i++)
  {
    power =ipow(2,i-1);
    c= (address & power)/power;
    if (c ==    1) //bit set - high
    {
      pulses[i][1] =600;//normal for bytes 1 to 8
      pulses[i][0] =1500;
      pulses[i+8][1] =600;  //inverse for bytes 9 to 16
      pulses[i+8][0] =500;
    } 
    else
    {
      pulses[i][1] =600;
      pulses[i][0] =500;
      pulses[i+8][1] =600;  //inverse for bytes 9 to 16
      pulses[i+8][0] =1500;
    }
  }
  //command
  for (int i = 17 ;i<25;i++)
  {
    power =ipow(2,i-17);
    c= (command & power)/power;
    if (c ==    1) //bit set - high
    {
      pulses[i][1] =600;//normal for bytes 1 to 8
      pulses[i][0] =1500;
      pulses[i+8][1] =600;  //inverse for bytes 9 to 16
      pulses[i+8][0] =500;
    } 
    else
    {
      pulses[i][1] =600;
      pulses[i][0] =500;
      pulses[i+8][1] =600;  //inverse for bytes 9 to 16
      pulses[i+8][0] =1500;
    }
  }
  //finish off
  pulses [33][1] = 600;
  pulses [33][0] = 25000; //this is approximate. need to find the message length and calculate this pause!
  //duplicate
  for (int i = 0; i<34;i++)
  {
    pulses [34+i][1] = pulses [i][1];
    pulses [34+i][0] = pulses [i][0];
  }

}
//****************************************************
void sendNECx(int address, int command)
{
  int power = 0;
  int c= 0;
  unsigned long int temp =0;
  //header first
  pulses [0][1] = 9000;
  pulses [0][0] = 4500;
  //Address first
  for (int i = 1 ;i<9;i++)
  {
    power =ipow(2,i-1);
    c= (address & power)/power;
    if (c ==    1) //bit set - high
    {
      pulses[i][1] =560;//normal for bytes 1 to 8
      pulses[i][0] =1690;
      pulses[i+8][1] =560;  //inverse for bytes 9 to 16
      pulses[i+8][0] =560;
    } 
    else
    {
      pulses[i][1] =560;
      pulses[i][0] =560;
      pulses[i+8][1] =560;  //inverse for bytes 9 to 16
      pulses[i+8][0] =1690;
    }
  }
  //command
  for (int i = 17 ;i<25;i++)
  {
    power =ipow(2,i-17);
    c= (command & power)/power;
    if (c ==    1) //bit set - high
    {
      pulses[i][1] =560;//normal for bytes 1 to 8
      pulses[i][0] =1690;
      pulses[i+8][1] =560;  //inverse for bytes 9 to 16
      pulses[i+8][0] =560;
    } 
    else
    {
      pulses[i][1] =560;
      pulses[i][0] =560;
      pulses[i+8][1] =560;  //inverse for bytes 9 to 16
      pulses[i+8][0] =1690;
    }
  }
  //finish off
  pulses [33][1] = 560;

  for (int i = 1; i<33;i++)
  {
    temp = temp + pulses[i][0] + pulses [i][1];
  }
  if ( temp <110000)
  {
    pulses [33][0] = 108000 - temp;//need to calculate this it is 108,000 less sum of bits
  }
  else
  {
    pulses [33][0] = 42000;  //approx value
  }
  //  repeat codes 
  for (int i =0;i<5;i = i +2)
  {
    pulses[34 +i][1]= 9000;
    pulses[34 + i][0]= 2250;
    pulses[35+i][1]= 560;
    pulses[35+i ][0]= 108000-560-2250-9000;
  }

}
//**************************************************************
void sendSIRC(int protocol, int address, int command)
{
  int power = 0;
  int c= 0;
  unsigned long int temp =0;
  //12 = SIRC12, 13 = SIRC15, 14 = SIRC20

    //header first common to all SIRC
  pulses [0][1] = 2400;
  pulses [0][0] = 600;
  //command is same for all 3 SIRC - 7 BIT
  for (int i = 1 ;i<8;i++)
  {
    power =ipow(2,i-1);
    c= (command & power)/power;
    if (c ==    1) //bit set - high
    {
      pulses[i][1] =1200;
      pulses[i][0] =600;
    } 
    else
    {
      pulses[i][1] =600;
      pulses[i][0] =600;
    }
  }
  if (protocol == 12 or protocol == 14)//address for SIRC12 & SIRC 20 5 Bit
  {
    //address  12 & 20 bit
    for (int i = 8 ;i<13;i++)
    {
      power =ipow(2,i-8);
      c= (address & power)/power;
      if (c ==    1) //bit set - high
      {
        pulses[i][1] =1200;
        pulses[i][0] =600;
      } 
      else
      {
        pulses[i][1] =600;
        pulses[i][0] =600;
      }
    }
  }
  if (protocol == 12)//remainder of bytes
  {
    pulses[12][1] =600;
    temp = 0;
    for (int i = 0; i<12;i++)
    {
      temp = temp +pulses [i][1] + pulses [i][0] ;
    }
    pulses[12][0] = 45000 - temp - pulses[12][0];

    for (int i=0;i<13;i++)// duplicate to give 3 lots
    {
      pulses [i+13][0] = pulses [i][0];
      pulses [i+13][1] = pulses [i][1];
      pulses [i+26][0] = pulses [i][0];
      pulses [i+26][1] = pulses [i][1];
    }

  }
  if (protocol == 14)//remainder of Bytes SIRC 20
  {
    for (int i=13;i<21;i++)//not sure what these bytes actuall do !!!!
    {
      pulses[i][1] =600;
      pulses[i][0] =600;

    }

    pulses [20][1] = 600;
    temp =0;
    for (int i = 0; i<20;i++)
    {
      temp = temp +pulses [i][1] + pulses [i][0] ;
    }
    pulses[20][0] = 45000 - temp - pulses[20][0];



    for (int i=0;i<21;i++)//duplicate for 3 lots
    {
      pulses [i+21][0] = pulses [i][0];
      pulses [i+21][1] = pulses [i][1];
      pulses [i+42][0] = pulses [i][0];
      pulses [i+42][1] = pulses [i][1];
    }

  }
  if (protocol == 13)//sirc15
  {
    //address  15 
    for (int i = 8 ;i<16;i++)
    {
      power =ipow(2,i-8);
      c= (address & power)/power;
      if (c ==    1) //bit set - high
      {
        pulses[i][1] =1200;
        pulses[i][0] =600;
      } 
      else
      {
        pulses[i][1] =600;
        pulses[i][0] =600;
      }
    }
    //finish off the resmainerd 3 times total
    //pulses [15][1] = 600;
    temp = 0;
    for (int i = 0; i<16;i++)
    {
      temp = temp +pulses [i][1] + pulses [i][0];
    }
    pulses[15][0] = 45000 - temp - pulses[15][0];


    for (int i = 0 ;i<16;i++)// duplicate codes for rest of packet 3 lots total
    {
      pulses[i +16][0] = pulses [i][0];
      pulses[i +16][1] = pulses [i][1];
      pulses[i +32][0] = pulses [i][0];
      pulses[i +32][1] = pulses [i][1];
    }
  }



}
//**********************************************
void sendDaewoo(int address, int command)
{
  int power = 0;
  int c= 0;
  unsigned long int temp =0;
  //header first
  pulses [0][1] = 8000;
  pulses [0][0] = 4000;
  //Address first
  for (int i = 1 ;i<9;i++)
  {
    power =ipow(2,i-1);
    c= (address & power)/power;
    if (c ==    1) //bit set - high
    {
      pulses[i][1] =550;//normal for bytes 1 to 8
      pulses[i][0] =1450;
      //pulses[i+8][1] =560;  //inverse for bytes 9 to 16
      //pulses[i+8][0] =560;
    } 
    else
    {
      pulses[i][1] =550;
      pulses[i][0] =450;
      //pulses[i+8][1] =560;  //inverse for bytes 9 to 16
      //pulses[i+8][0] =1690;
    }
  }
  pulses[9][1] =550;
  pulses[9][0] =4000;

  //command

  for (int i = 10 ;i<18;i++)
  {
    power =ipow(2,i-10);
    c= (command & power)/power;
    if (c ==    1) //bit set - high
    {
      pulses[i][1] =550;//normal for bytes 1 to 8
      pulses[i][0] =1450;
      // pulses[i+8][1] =560;  //inverse for bytes 9 to 16
      // pulses[i+8][0] =560;
    } 
    else
    {
      pulses[i][1] =550;
      pulses[i][0] =450;
      //pulses[i+8][1] =560;  //inverse for bytes 9 to 16
      //pulses[i+8][0] =1690;
    }
  }
  //finish off


  pulses [18][1] = 550;

  for (int i = 1; i<18;i++)
  {
    temp = temp + pulses[i][0] + pulses [i][1];
  }
  if ( temp <60000)
  {
    pulses [18][0] = 60000 - 550-temp;//need to calculate this it is 60000 less sum of bits
  }
  //  repeat
  for (int i =0;i<19;i = i++)
  {
    pulses[19 +i][1]= pulses[i][1];
    pulses[19 + i][0]= pulses[i][0];

  }

}

//***********************************************************
void showProtocol()//displays the current IR code protocol
{

  char* values[pulseSamples];  // 
  float temp1 =0;  
  float temp2 =0;
  float temp3 =0;
  int protocol = 99;
  int showIndex =0 ; 
  do
  {

    for (int i = 0;i<pulseSamples;i++)
    {
      values[i] ="";
    }

    //SIRC 12, 15, 20 bit
    //12 bit = 7 bit Command array 1 to 7, 5 bit Address array 8 to 12 LSB first
    //15 bit = 7 bit Command array 1 to 7, 8 bit Address array 8 to 15
    //20 bit = 7 bit Command array 1 to 7, 5 bit Address array 8 to 12, 8 bit extension array 13 to 20
    int deviceAddress =0;
    int deviceCommand =0;


    //*************************************** SIRC12
    temp1 = (float(pulses[0][1])/float (pulses[0][0]));
    temp2 = (float(pulses[13][1])/float (pulses[13][0]));

    if (temp1 >3.9 and temp1 <5 and temp2 >3.9 and temp2 <5) //both 2400:600us, 4:1
    {
      protocol = 1;//SIRC12
      values [0] = "SIRC12";
    }
    //*************************************** SIRC15
    temp1 = (float(pulses[0][1])/float (pulses[0][0]));
    temp2 = (float(pulses[16][1])/float (pulses[16][0]));

    if (temp1 >3.9 and temp1 <5 and temp2 >3.9 and temp2 <5) //both 2400:600us, 4:1
    {
      protocol = 2;//SIRC15
      values [0] = "SIRC15";
    }
    //*************************************** SIRC20
    temp1 = (float(pulses[0][1])/float (pulses[0][0]));
    temp2 = (float(pulses[21][1])/float (pulses[21][0]));
    if (temp1 >3.9 and temp1 < 5 and temp2 >3.9 and temp2 <5) //both 2400:600us, 4:1
    {
      protocol = 3;//SIRC20
      values [0] = "SIRC20";
    }
    //*************************************** NEC
    temp1 = (float(pulses[0][1])/float (pulses[0][0]));
    if (temp1 >1.8 and temp1 <2.5)//9000:4500us, 2:1
    {
      temp2 = (float(pulses[34][1])/float (pulses[34][0]));
      if (temp2 >3.8 and temp2 < 4.5 )//9000:2250 4:1  repeat code
      {
        protocol = 4;//NEC
        values [0] = "NEC";
        values [34] = "NEC";
      }
    }
    //*************************************** Sharp
    temp1 = (float(pulses[0][1])/float (pulses[0][0]));
    temp2 = (float(pulses[0][1])/float (pulses[0][0]));
    temp3 = (float(pulses[15][1])/float (pulses[15][0]));
    if (temp1 <0.6 and temp2  <0.6 and temp3 < 0.01) // "0" =320:680, 0.47:1, "1" =320:1680, 0.19:1,bits 0 to 4 is 5 bit address, bits 5 to 12 is 8 bit command, bit 13 is expansion, bit 14 is chk bit.
    {

      protocol = 5;//Sharp
      values [15] = "Sharp";  // no lead in, first bit is address LSB
      values [31] = "Sharp";  // no lead in, first bit is address LSB
      values [47] = "Sharp";  // no lead in, first bit is address LSB
      values [63] = "Sharp";  // no lead in, first bit is address LSB
    }
    //************************************** Panasonic
    temp1 = (float(pulses[0][1])/float (pulses[0][0]));//3500:1750, 2:1, 2.068
    temp2 = (float(pulses[50][1])/float (pulses[50][0]));
    if ((temp1 >1.9 and temp1 <2.5)and (temp2 >1.9 and temp2 <2.5)) // 
    {
      protocol = 6;//
      values [0] = "Panasonic";  // 
      values [50] = "Panasonic";  //
    }
    //************************************** Pioneer
    temp1 = (float(pulses[0][1])/float (pulses[0][0]));//8000:4000, 2:1, 2.068
    temp2 = (float(pulses[34][1])/float (pulses[34][0]));
    if ((temp1 >1.9 and temp1 <2.5)and (temp2 >1.9 and temp2 <2.5)) // 
    {
      protocol = 7;//
      values [0] = "Pioneer";  // 
      values [33] = "Pioneer";  //
    }

    //************************************** Samsung32
    temp1 = (float(pulses[0][1])/float (pulses[0][0]));//4500:4500
    temp2 = (float(pulses[33][1])/float (pulses[33][0])); //560/57000
    if (temp1 >0.9 and temp1 <1.2) // 
    {
      if ((pulses[0][1] >3500) and (pulses [34][1] >3500))
      {
        protocol = 8;//
        values [0] = "Samsung32";  // 
        values [34] = "Samsung32";  //
      }
    }
    //************************************** Samsung38
    temp1 = (float(pulses[0][1])/float (pulses[0][0]));//4500:4500
    temp2 = (float(pulses[38][1])/float (pulses[38][0])); //560/57000
    if ((temp1 >0.9 and temp1 <1.2)and (temp2 <0.06)) // 
    {
      protocol = 9;//
      values [0] = "Samsung38";  // 
      values [39] = "Samsung38";  //
    }
    //************************************** RC5

    temp1=pulses[0][1];
    temp2 = pulses [0][0];
    if (temp1>750 and temp1 <1000) 
    {
      if (temp2>750 and temp2 <1000) 
      {
        temp1 = (float(pulses[12][1])/float (pulses[12][0]));
        if (temp1 <0.1)
        { 
          protocol = 10;//
          //values [12] = "RC5";  // 
          // values [23] = "RC5";  //
        }

      }
    }

    //************************************** Daewoo
    temp1 = (float(pulses[0][1])/float (pulses[0][0]));//8000:4000
    temp2 = (float(pulses[18][0])/float (pulses[18][1])); //550 
    if ((temp1 >1.9 and temp1 <2.5)and (temp2 >30)) // 
    {
      protocol = 11;//
      values [0] = "Daewoo";  // 
      values [19] = "Daewoo";  //
    }

    //***********************************************************
    for (int i =0; i<pulseSamples;i++)
    {
      //*************************************** SIRC12,15,20
      if (protocol >=1 and protocol <=3)//SIRC
      {
        values[i] ="X";
        temp1 = (float(pulses[i][1])/float (pulses[i][0]));
        //Serial.println (temp);
        if ( temp1 < 1.8 )//600:600, 1:1
        {
          values[i] ="0";
        }
        if (temp1 >1.8 and temp1 <3.0 )//1200:600, 2;1
        {
          values[i] ="1";
        }
        if (temp1 >3.9 and temp1 <4.8)//2400:600us, 4:1
        {

          values [i] = "SIRC";

        }  

      }   
      //*************************************** NEC
      if (protocol ==4)//NEC

      {
        temp1 = (float(pulses[i][1])/float (pulses[i][0]));
        //Serial.println (temp);
        if ( temp1 >0.9 and temp1 < 1.5 )//560:560, 1:1
        {
          values[i] ="0";
        }
        if (temp1 <0.5 )//320:1680,  ).19:1
        {
          values[i] ="1";
        }
        if (temp1 >3.8 and temp1 < 4.5 )//9000:2250 4:1  repeat code
        {
          values[i] ="Rpt";
        }

      }
      //*************************************** Sharp
      if (protocol ==5)//Sharp "0" =320:680, 0.47:1, "1" =320:1680, 0.19:1
      {
        temp1 = (float(pulses[i][1])/float (pulses[i][0]));
        //Serial.println (temp);
        if ( temp1 > 0.3 and temp1 < 0.8 )//320:680, 0.47:1
        {
          values[i] ="0";
        }
        if (temp1 >0.1 and temp1 <0.3 )//"1" =320:1680, 0.19:1
        {
          values[i] ="1";
        }

        if (temp1<0.1 )//320:40000. 0.008:1

        {
          values [i] = "Sharp";
        }

      }   

      //*************************************** Pana
      if (protocol ==6)//Panasonic 
      {
        temp1 = (float(pulses[i][1])/float (pulses[i][0]));
        //Serial.println (temp);
        if ( temp1 > 0.8 and temp1 < 2.2)//435/435
        {
          values[i] ="0";
        }
        if (temp1 >0.2 and temp1 <0.6 )//"1" = 435/1300
        {
          values[i] ="1";
        }

        if (temp1 > 1.8 and temp1 <2.2 )//3500/1700

        {
          values [i] = "Panasonic";
        }

      }   
      //*************************************** Pion
      if (protocol ==7)//Pioneer
      {
        temp1 = (float(pulses[i][1])/float (pulses[i][0]));
        //Serial.println (temp);
        if ( temp1 > 0.9 and temp1 < 1.5 ) //584:472
        {
          values[i] ="0";
        }
        if (temp1 >0.2 and temp1 <0.6 )//"1" =
        {
          values[i] ="1";
        }

        if (temp1 > 1.9 and temp1 <2.5 )//8000:4000, 2:1

        {
          values [i] = "Pioneer";
        }

      }   
      //*********************************************
      if (protocol ==8)//Samsung32
        //    temp1 = (float(pulses[0][1])/float (pulses[0][0]));//4500:4500
        //   temp2 = (float(pulses[33][1])/float (pulses[33][0])); //560/57000
        //   if ((temp1 >0.9 and temp1 <1.2)and (temp2 <0.06)) // 

      {
        temp1 = (float(pulses[i][1])/float (pulses[i][0]));
        //Serial.println (temp);
        if ( temp1 > 0.9 and temp1 < 1.8 ) //650 492
        {
          values[i] ="0";
        }
        if (temp1 >0.2 and temp1 <0.6 )// 640/1624
        {
          values[i] ="1";
        }

        if (temp1 > 0.8 and temp1 <1.2 )//4500/4500

        {
          if (pulses [i][1] >3500)
          {
            values [i] = "Samsung32";
          }
        }

      }   
      //***************************************************
      if (protocol ==9)//Samsung38
        //    temp1 = (float(pulses[0][1])/float (pulses[0][0]));//4500:4500
        //   temp2 = (float(pulses[33][1])/float (pulses[33][0])); //560/57000
        //   if ((temp1 >0.9 and temp1 <1.2)and (temp2 <0.06)) // 

      {
        temp1 = (float(pulses[i][1])/float (pulses[i][0]));
        //Serial.println (temp);
        if ( temp1 > 0.9 and temp1 < 1.8 ) //650 492
        {
          values[i] ="0";
        }
        if (temp1 >0.2 and temp1 <0.6 )// 640/1624
        {
          values[i] ="1";
        }

        if (temp1 > 0.8 and temp1 <1.2 )//4500/4500

        {
          if (pulses [i][1] >3500)
          {
            values [i] = "Samsung38";
          }
          if (pulses [17][0] >3500)
          {
            values [17] = "Samsung38";
          }
        }

      }   

      //*************************************** RC5
      if (protocol ==10)//RC5

      {
        String RC5Change = "UP";  
        int RC5Counter = 0;
        for (int i =0;i<pulseSamples;i++)
        {
          if ( RC5Change == "UP") 
          {
            values[RC5Counter] = "1";
            if (RC5Counter < pulseSamples)
            {
              RC5Counter++;
            }
          }
          if ( pulses[i][1] > 1200 and RC5Change == "UP" )
          {
            RC5Change = "DN";
          }
          if ( RC5Change == "DN")  //  1.short pulse could be 0 or 1
          {
            values[RC5Counter] = "0";
            if (RC5Counter < pulseSamples)
            {
              RC5Counter++;
            }
          }
          if ( pulses[i][0] > 1200 and RC5Change == "DN" )
          {
            RC5Change = "UP";
          }
          if ( pulses[i][0] >50000) //end of packet
          {

            RC5Change == "UP";
          }

        }
        values[0] = "RC5";


      }    

      //*************************************** Daewoo

      if (protocol ==11)//Daewoo
      {
        temp1 = (float(pulses[i][1])/float (pulses[i][0]));
        //Serial.println (temp);

        if (temp1 >1.0 and temp1 <1.5 )// 550/450
        {
          values[i] ="0";
        }
        if ( temp1 > 0.3 and temp1 < 0.5 ) //550/1450
        {
          values[i] ="1";
        }

      }      
    }//end for


    myGLCD.clrScr();
    myGLCD.setColor(textColor);
    menuData[0] =  " Up";  
    menuData[1] =  "Down";  
    menuData[2] =  "Test";  
    menuData[3] =  "Exit";
    drawMenu (125,275,2,2,50,45,5, 5,menuData,SmallFont);
    //was do here
    myGLCD.setColor(textColor);
    for (int i = showIndex ; i<showIndex +30;i++)
    {
      //myGLCD.print ("  ",5,12 *(i+1-showIndex));
      if (String(i).length() == 1)
      {
        myGLCD.print ("0" + String (i),5,12 *(i+1-showIndex));
      }
      else
      {
        myGLCD.print (String (i),5,12 *(i+1-showIndex));
      }//myGLCD.print ("-", 20, 12*(i+1) );

      myGLCD.print ("      ",25,12 *(i+1-showIndex));
      myGLCD.print (String (values[i]),25,12 *(i+1-showIndex));


      // myGLCD.print ("-", 60, 12*(i+1) );
      //myGLCD.print ("      ",68, 12 *(i+1-showIndex));
      //myGLCD.print (String(values[i]),68, 12 *(i+1-showIndex));


    }
    for (int i = showIndex + 30 ; i< showIndex + 50;i++)
    {
      myGLCD.print (String (i),120,12 *(i-29-showIndex));
      //myGLCD.print ("-", 120, 12*(i-30) );
      myGLCD.print ("      ",140,12 *(i-29-showIndex));
      myGLCD.print (String (values[i]),140,12 *(i-29-showIndex));


      //myGLCD.print ("      ",183, 12 *(i-30-showIndex));
      //myGLCD.print (String(values[i]),183, 12 *(i-30-showIndex));
    }

    //Calculate command  and address
    deviceCommand = 0;
    deviceAddress =0;
    if (protocol >=1 or protocol <= 3)//SIRC15 or SIRC12/20 OK
    {

      deviceCommand =(atoi(values[1]) *1)+(atoi(values[2]) *2)+(atoi(values[3]) *4)+(atoi(values[4]) *8)+(atoi(values[5]) *16)+(atoi(values[6]) *32)+(atoi(values[7]) *64);

      if (values[13] =="SIRC" or values [21] =="SIRC")// 12 bit & 20 bit
      {
        deviceAddress =(atoi(values[8]) *1)+(atoi(values[9]) *2)+(atoi(values[10]) *4)+(atoi(values[11]) *8)+(atoi(values[12]) *16);
      }
      if (values[16] =="SIRC")// 15 bit
      {
        deviceAddress =(atoi(values[8]) *1)+(atoi(values[9]) *2)+(atoi(values[10]) *4)+(atoi(values[11]) *8)+(atoi(values[12]) *16)+(atoi(values[13]) *32)+(atoi(values[14]) *64)+(atoi(values[15]) *128);
      }
    }

    if (protocol ==4 or protocol == 7 or protocol == 8)//NEC , Pioneer , Samsung32
    {
      deviceAddress =(atoi(values[1]) *1)+(atoi(values[2]) *2)+(atoi(values[3]) *4)+(atoi(values[4]) *8)+(atoi(values[5]) *16)+(atoi(values[6]) *32)+(atoi(values[7]) *64)+(atoi(values[8]) *128);
      deviceCommand =(atoi(values[17]) *1)+(atoi(values[18]) *2)+(atoi(values[19]) *4)+(atoi(values[20]) *8)+(atoi(values[21]) *16)+(atoi(values[22]) *32)+(atoi(values[23]) *64)+(atoi(values[24]) *128);
    }
    if (protocol ==5)//Sharp 5 bit address, 8 bit command
    {
      deviceAddress =(atoi(values[0]) *1)+(atoi(values[1]) *2)+(atoi(values[2]) *4)+(atoi(values[3]) *8)+(atoi(values[4]) *16);
      deviceCommand =(atoi(values[5]) *1)+(atoi(values[6]) *2)+(atoi(values[7]) *4)+(atoi(values[8]) *8)+(atoi(values[9]) *16)+(atoi(values[10]) *32)+(atoi(values[11]) *64)+(atoi(values[12]) *128);
    }
    if (protocol ==6)//Pana OK
    {
      deviceAddress =(atoi(values[17]) *1)+(atoi(values[18]) *2)+(atoi(values[19]) *4)+(atoi(values[20]) *8)+(atoi(values[21]) *16)+(atoi(values[22]) *32)+(atoi(values[23]) *64)+(atoi(values[24]) *128);
      //sub address bits 25 to 32 not decoded.
      deviceCommand =(atoi(values[33]) *1)+(atoi(values[34]) *2)+(atoi(values[35]) *4)+(atoi(values[36]) *8)+(atoi(values[37]) *16)+(atoi(values[38]) *32)+(atoi(values[39]) *64)+(atoi(values[40]) *128);    
    }
    if (protocol ==9)//Samsung38 //not certain of these!
    {
      deviceAddress =(atoi(values[1]) *1)+(atoi(values[2]) *2)+(atoi(values[3]) *4)+(atoi(values[4]) *8)+(atoi(values[5]) *16)+(atoi(values[6]) *32)+(atoi(values[7]) *64)+(atoi(values[8]) *128);
      deviceCommand =(atoi(values[22]) *1)+(atoi(values[23]) *2)+(atoi(values[24]) *4)+(atoi(values[25]) *8)+(atoi(values[26]) *16)+(atoi(values[27]) *32)+(atoi(values[28]) *64)+(atoi(values[29]) *128);
    }
    if (protocol ==10)//RC5
    {
      deviceAddress =(atoi(values[7]) *1)+(atoi(values[6]) *2)+(atoi(values[5]) *4)+(atoi(values[4]) *8)+(atoi(values[3]) *16);
      deviceCommand =(atoi(values[13]) *1)+(atoi(values[12]) *2)+(atoi(values[11]) *4)+(atoi(values[10]) *8)+(atoi(values[9]) *16)+(atoi(values[8]) *32);    
    }

    if (protocol ==11)//Daewoo
    {
      deviceAddress =(atoi(values[1]) *1)+(atoi(values[2]) *2)+(atoi(values[3]) *4)+(atoi(values[4]) *8)+(atoi(values[5]) *16)+(atoi(values[6]) *32)+(atoi(values[7]) *64)+(atoi(values[8]) *128);
      deviceCommand =(atoi(values[10]) *1)+(atoi(values[11]) *2)+(atoi(values[12]) *4)+(atoi(values[13]) *8)+(atoi(values[14]) *16)+(atoi(values[15]) *32)+(atoi(values[16]) *64)+(atoi(values[17]) *128);    
    }

    //Serial.print ("Address= ");
    //Serial.println (deviceAddress);
    //Serial.print ("Command= ");
    //Serial.println (deviceCommand);
    myGLCD.print ("Address: ",10,380);
    myGLCD.print (String(deviceAddress),75,380);
    myGLCD.print ("Command: ",125,380);
    myGLCD.print (String(deviceCommand),190,380);

    do
    {
      getKey();
      //Serial.print ("In showData.  Key num is: ");
      //Serial.println (keyNum);
      switch (keyNum)
      {
      case 1:
        showIndex = showIndex +8;
        if (showIndex >pulseSamples - 50)
        {
          showIndex = pulseSamples - 50;
        }
        break;
      case 0://
        showIndex= showIndex -8;
        if (showIndex <0)
        {
          showIndex =0;
        }
        exit;
        break;
      case 2://Monitor IR
        myGLCD.setColor(textColor);
        myGLCD.print ( "                                    ", 10,380);
        myGLCD.print   ("Press an IR Remote Key: ", 10,380);
        delay (200);
        monitorIr();
        break;

      case 3://exit
        screenIndex = 7 ;
        //keyNum =100;
        //exit;
        break;
      }
    }
    while (keyNum >3);
    //Serial.print ("In showData.  showIndex = ");
    //Serial.println (showIndex);
    // }while (keyNum <=99);

  }
  while (keyNum < 3);//exit if keynum == 3
  Serial.print ("In showProtocol.  Exiting function");

}

//***********************************************************
void processSettingsScreen()
{

  int oldX = 0;
  int currentX = 0;
  char* sText[22] = {
  };
  for (int i; i< 22;i++)
  {
    menuData[i] = "";
    sText[i]="";
  }

  menuData[0]= "X";
  menuData[17]= "+";
  menuData[19]= "-";
  menuData[21]= "E";
  drawMenu(15, 7, 2, 11, 15, 25,95,10,menuData, SmallFont);  

  //drawMenu(int leftX, int topY, int cols, int rows, int width, int height,int colGap,int rowGap, char* lbl[], font)
  char b[25];
  char c[25];
  char d[25];
  String dataStr = "OffTime " + String(offTime);
  dataStr.toCharArray(b,25);
  sText [0] =  b;
  dataStr = "IRTout " + String(irTimeOut);
  dataStr.toCharArray(c,25);
  sText [1] = c;

  if (roundUp)
  {
    dataStr = "RoundUp On ";
  }
  else
  {
    dataStr = "RoundUp Off";
  }
  dataStr.toCharArray(d,25);
  sText [2] = d;
  sText[17] = "Value +";
  sText[19] = "Value -";
  sText[21] = "Exit";

  //for (int i = 0; i <20;i= i +2)
  //{
  //    myGLCD.setColor(textColor);
  //    myGLCD.print (sText[i],10,i*10 );
  //}
  //for (int i = 1; i <20;i= i +2)
  //{
  //    myGLCD.setColor(textColor);
  //    myGLCD.print (sText[i],100,i*10);
  //}
  int i= 0;
  for (int y = 0 ;y<11; y++)//do rows second
  {
    for (int x=0; x<2; x++)//do columns first
    {

      myGLCD.setColor(textColor);
      myGLCD.print (sText[i],35 + (x * 110) + (x * 5), 15 +(y * 30) +(y *5) );
      i++;
      //int x1 = leftX +(x*width)+ (x *colGap);    
      //int y1 = topY + (y *height) +(y * rowGap);
      //int x2 = leftX +((x+1) *width)+ (x *colGap);     
      //int y2 = topY + ((y+1) *height) +(y * rowGap);
    }
  }


  // processSettingsScreen();

  // myGLCD.setColor(textColor);
  // myGLCD.print ("Fred",10,10);
  do
  {
    getKey();
    if (keyNum != 21 and keyNum !=19 and keyNum != 17 and keyNum !=99) //don't change for "Exit" key
    {

      //myGLCD.setColor(textColor);
      //myGLCD.print ("Fred",10,10);
      menuData[oldX] =" ";
      oldX= keyNum;
      menuData[keyNum] ="X";
      drawMenu(15, 7, 2, 11, 15, 25,95,10,menuData, SmallFont);  
    }
    if (keyNum ==17 or keyNum == 19)
    {
      switch (keyNum)
      {
      case 17:// +
        switch (oldX)
        {
        case 0://Offtime
          offTime++;
          break;

        case 1://IR timeout
          irTimeOut = irTimeOut +50;
          if (irTimeOut >6000)
          {
            irTimeOut = 6000;
          }

          break; 
        case 2:  //          roundUp
          roundUp = !roundUp;
          break;

        }
        break;
      case 19://-
        switch (oldX)
        {
        case 0://Offtime
          offTime--;
          break;
        case 1://IR Timeout
          irTimeOut = irTimeOut -50;
          if (irTimeOut <1000)
          {
            irTimeOut = 1000;
          }
          break;
        case 2:  //  roundUp
          roundUp = !roundUp;
          break;
        }

        break;
      default:
        break;
      }
      i = 0;
      dataStr = "OffTime " + String(offTime);
      dataStr.toCharArray(b,25);
      sText [0] =  b;
      dataStr = "IRTout " + String(irTimeOut);
      dataStr.toCharArray(c,25);
      sText [1] = c;
      if (roundUp)
      {
        dataStr = "RoundUp On ";
      }
      else
      {
        dataStr = "RoundUp Off";
      }
      dataStr.toCharArray(d,25);
      sText [2] = d;




      for (int y = 0 ;y<10; y++)//do rows second
      {
        for (int x=0; x<2; x++)//do columns first
        {

          myGLCD.setColor(textColor);
          myGLCD.print (sText[i],35 + (x * 110) + (x * 5), 15 +(y * 30) +(y *5) );
          i++;
          //int x1 = leftX +(x*width)+ (x *colGap);    
          //int y1 = topY + (y *height) +(y * rowGap);
          //int x2 = leftX +((x+1) *width)+ (x *colGap);     
          //int y2 = topY + ((y+1) *height) +(y * rowGap);
        }
      }

    }
  }
  while (keyNum != 21  );
  writeEepromInitFile();
  screenIndex = 0;
}
//***************************************************
void showData()
{
  int showIndex =0 ; 
  myGLCD.clrScr();
  myGLCD.setColor(textColor);
  menuData[0] =  " Up";  
  menuData[1] =  "Down";  
  menuData[2] =  "Test";  
  menuData[3] =  "Exit";
  drawMenu (125,280,2,2,50,45,5, 5,menuData,SmallFont);

  do
  {
    myGLCD.setColor(textColor);
    for (int i = showIndex ; i<showIndex +30;i++)
    {
      //myGLCD.print ("  ",5,12 *(i+1-showIndex));
      if (String(i).length() == 1)
      {
        myGLCD.print ("0" + String (i),5,12 *(i+1-showIndex));
      }
      else
      {
        myGLCD.print (String (i),5,12 *(i+1-showIndex));
      }//myGLCD.print ("-", 20, 12*(i+1) );

      myGLCD.print ("      ",25,12 *(i+1-showIndex));
      myGLCD.print (String (pulses[i][1]),25,12 *(i+1-showIndex));


      // myGLCD.print ("-", 60, 12*(i+1) );
      myGLCD.print ("      ",68, 12 *(i+1-showIndex));
      myGLCD.print (String(pulses[i][0]),68, 12 *(i+1-showIndex));


    }
    for (int i = showIndex + 30 ; i< showIndex + 52;i++)
    {
      myGLCD.print (String (i),120,12 *(i-29-showIndex));
      //myGLCD.print ("-", 120, 12*(i-30) );
      myGLCD.print ("      ",140,12 *(i-29-showIndex));
      myGLCD.print (String (pulses[i][1]),140,12 *(i-29-showIndex));
      // myGLCD.print ("-", 170, 12*(i-30) );
      myGLCD.print ("      ",183, 12 *(i-29-showIndex));
      myGLCD.print (String(pulses[i][0]),183, 12 *(i-29-showIndex));


    }

    do
    {
      getKey();
      //Serial.print ("In showData.  Key num is: ");
      //Serial.println (keyNum);
      switch (keyNum)
      {
      case 1:
        showIndex = showIndex +8;
        if (showIndex >pulseSamples - 53)
        {
          showIndex = pulseSamples - 53;
        }
        break;
      case 0://
        showIndex= showIndex -8;
        if (showIndex <0)
        {
          showIndex =0;
        }
        exit;
        break;
      case 2 ://Test
        myGLCD.setColor(textColor);
        myGLCD.print ( "                                    ", 10,380);
        myGLCD.print   ("Press an IR Remote Key: ", 10,380);
        delay (200);
        monitorIr();

        break;
      case 3://exit
        screenIndex = 7 ;
        //keyNum =100;
        //exit;
        break;
      }
    }
    while (keyNum >3);
    //Serial.print ("In showData.  showIndex = ");
    //Serial.println (showIndex);
    // }while (keyNum <=99);

  }
  while (keyNum < 3);
  Serial.print ("In showData.  Exiting function");
}


//***************************************************
void processScreen(int ubound, char* lbl[])//  reads the button key press and decides the action required
{
  //writePulseDataX ();
  myGLCD.setFont(SmallFont);
  myGLCD.setColor(textColor);
  myGLCD.print ("Device selected is:", 10,380);
  myGLCD.print (labelDevice[deviceIndex], 175,380);
  //myGLCD.print (String (deviceIndex), 175,380);
  int exitBtn, progBtn = 100;  //Exit and prog button

  String labelString ="";
  Serial.println ();
  Serial.print ("In processScreen. Screen/Menu Index is:  ");
  Serial.println (screenIndex);
  Serial.print ("In processScreen. Mode is ");
  Serial.println (mode);

  for (int i = 0; i <ubound;i++)//find the indexes for the Programme button
  {
    if (lbl[i]== "/C00Prog")
    {
      Serial.print ("In processScreen.  Programme button is = ");
      Serial.println (i);
      progBtn = i ; //  **** changed to keynum = Index*******keyNum value  = Item index + 1.  Item Index = keyNum -1
    }
  }
  //******* Main Loop
  //Serial.print ("In processScreen.  Free RAM is: ");
  //Serial.println(freeRam());
  do
  {
    getKey();
    if (keyNum < 99)
    {

      labelString = String(lbl[keyNum]); //converts char array to string
      //Serial.print ("In processScreen. Mode is ");
      //Serial.println (mode);

      //Serial.print("In processScreen. labelString selected = ");
      //Serial.println(labelString);
      if (labelString.startsWith ("/T"))//Toggle Mode
      {
        String toggleNumStr = labelString.substring(2,4);
        int toggleNum;
        toggleNum = toggleNumStr.toInt();
        Serial.print("In processScreen. Toggle number is: ");
        Serial.println(toggleNum);
        switch (toggleNum)
        {
        case 0://  //Round Up
          roundUp = !roundUp;
          myGLCD.setColor(textColor);
          myGLCD.print ( "                                    ", 10,380);
          myGLCD.print   ("Round Up Status is: ", 10,380);
          myGLCD.print (String(roundUp),175,380);
          writeEepromInitFile();
          //return;
          break;
        }
      }


      //********************
      //  /A Analysis
      //********************
      if (labelString.startsWith ("/A"))//Analysis Mode
      {
        String analysisNumStr = labelString.substring(2,4);
        int analysisNum;
        analysisNum = analysisNumStr.toInt();
        Serial.print("In processScreen. Analysis number is: ");
        Serial.println(analysisNum);
        switch (analysisNum)
        {
        case 0://
          showData();
          return;
          break;
        }
      }
      //********************
      //  /N Numeric
      //********************
      if (labelString.startsWith ("/N"))//Numeric calculation
      {
        myGLCD.setColor(textColor);
        String calcNumStr = labelString.substring(2,4);
        int calcNum;
        calcNum = calcNumStr.toInt();
        Serial.print("In processScreen. Numeric item is: ");
        Serial.print(calcNum);
        switch (screenIndex)
        {
        case 7://CPanel previously used for settings
          switch (calcNum)
          {
          case 0:// 

            break;
          case 1://
            break;
          case 2:
            break;
          }
          break;
        case 9://IR test Screen
          switch (calcNum)
          {
          case 0://Hi+
            dutyHigh ++;
            Serial.println ("increasing Pulse width duty");
            myGLCD.print ("Pulse width duty Hi:       ",10,380);
            myGLCD.print (String(dutyHigh),175, 380);
            break;

          case 1://Hi-
            dutyHigh --;
            if (dutyHigh <= 1){
              dutyHigh =1;
            }
            myGLCD.print ("Pulse width duty Hi:        ",10,380);
            myGLCD.print (String(dutyHigh),175, 380);
            break;

          case 2://Lo+
            dutyLow ++;
            myGLCD.print ("Pulse width duty Lo:        ",10,380);
            myGLCD.print (String(dutyLow),175, 380);
            break;

          case 3://Lo-
            dutyLow --;
            if (dutyLow <= 1){
              dutyLow =1;
            }
            myGLCD.print ("Pulse width duty Lo:        ",10,380);
            myGLCD.print (String(dutyLow),175, 380);

            break;
          case 4://PL +
            adjustModulationLength ++;
            myGLCD.print ("Modulation PW:                ",10,380);
            myGLCD.print (String(adjustModulationLength),175, 380);

            break;
          case 5://Pl-
            adjustModulationLength --;
            if (adjustModulationLength <= 1){
              adjustModulationLength =1;
            }
            myGLCD.print ("Modulation PW:               ",10,380);
            myGLCD.print (String(adjustModulationLength),175, 380);
            break;
          case 6://Dur % +
            adjustPulseDuration ++;
            if (adjustPulseDuration <= 1){
              adjustPulseDuration =1;
            }
            myGLCD.print ("Pulse Duration % =           ",10,380);
            myGLCD.print (String(adjustPulseDuration),175, 380);

            break;
          case 7://Dur % -
            adjustPulseDuration --;
            if (adjustPulseDuration <= 1){
              adjustPulseDuration =1;
            }
            myGLCD.print ("Pulse Duration % =          ",10,380);
            myGLCD.print (String(adjustPulseDuration),175, 380);

            break;
          case 8://Gap % +
            adjustPauseDuration ++;
            if (adjustPauseDuration <= 1){
              adjustPauseDuration =1;
            }
            myGLCD.print ("Pulse Gap % =              ",10,380);
            myGLCD.print (String(adjustPauseDuration),175, 380);

            break;
          case 9://Gap % -
            adjustPauseDuration --;
            if (adjustPauseDuration <= 1){
              adjustPulseDuration =1;
            }
            myGLCD.print ("Pulse Gap % =             ",10,380);
            myGLCD.print (String(adjustPauseDuration),175, 380);

            break;

          case 10: //Save data
            writeEepromInitFile();
            myGLCD.print ("Settings Saved.                ",10,380);
            break;
          default:
            break;
            delay (500);
          }  
        }
      }
      /*
      //********************
       //  /M Macro   
       //********************
       if (labelString.startsWith("/M"))//Macro
       {
       //Play the macro recording keyNum
       currentMacro = keyNum;
       readMacroData();  //macro[] is in format X-Y-ZZ.txt as chr
       //int intMDI, intMSI, intMKN;  //working variables
       for (int i =0;i<macroArrayLength;i++)
       {
       if (macro[i].length()  > 4)
       {
       String stringMDI = (macro[i].substring(0,1));//get the device 
       int intMDI = stringMDI.toInt();
       String stringMSI = (macro[i].substring(2,3));//get the screen index 
       int intMSI = stringMSI.toInt();
       String stringMKN = (macro[i].substring(4,6));//get the screen KeyNum 
       int intMKN = stringMKN.toInt();
       
       Serial.print ("In processScreen.  Macro Calling readPulseData: ");
       Serial.print(intMDI);
       Serial.print ("-");
       Serial.print (intMSI);
       Serial.print ("-");
       Serial.print (intMKN);
       Serial.println ();
       
       readPulseData (intMDI, intMSI, intMKN);
       Serial.println ("In processScreen.  Macro Calling transmitIR");
       Serial.println ();
       transmitIr();
       
       
       Serial.println ("In processScreen.  Macro Returned from transmitIR");
       }
       else
       {
       Serial.println ("In processScreen.  Empty Macro element");
       }
       }
       //runMacro();
       }
       */
      //   /S  sub Menu
      if (labelString.startsWith("/S"))//Sub Menu

      {
        Serial.println ("In processScreen.  Yes starts with /S");        
        Serial.print("In processScreen.  labelString = ");
        Serial.println(labelString);
        String subMenuString = (labelString.substring (2,4)); //substring (start index, end index) base is zero, returns a single digit
        Serial.print("In processScreen.  subMenuString = ");
        Serial.println(subMenuString);

        int subMenuInt = subMenuString.toInt(); //String to Int
        screenIndex = subMenuInt;
        if (deviceIndex == 0 and subMenuInt ==2) //TV and Input screen special case
        {
          screenIndex = 12;
        }
        if (deviceIndex == 6 and subMenuInt ==2) //Amp and Input screen special case
        {
          screenIndex = 13;
        }




        Serial.print("In processScreen. screenIndex = ");
        Serial.println(screenIndex);
        Serial.print("In processScreen. keyNum ** = ");
        Serial.println (keyNum);
        Serial.println ("In processScreen. Exiting function");
        return;
      }
      //************************
      //* /D Device            *
      //************************
      if (labelString.startsWith("/D")) //Device
      {
        selectDevice(labelString);
      }
      // start programming IR button
      if (keyNum == progBtn)
      {
        mode = "PROGRAM";
        myGLCD.setColor(textColor);
        myGLCD.print ("Press a button.  Prog to end       ", 10,380);
        delay(1000);
        programBtn(lbl,progBtn);
      }
      /*
      //  /C1REcord
       if (labelString.startsWith("/C1Record")) //Macro function
       {
       if (mode == "MACRORECORD")
       {
       Serial.println ("In processScreen. Ending Macro Record");
       mode = ("NIL");//end macro record
       myGLCD.print ("Ending Macro Recording       ",10,380);
       //Save the Macro File Macroxx.txt
       writeMacroFile ();
       myGLCD.print ("                             ",10,380);
       
       }     
       else
       {
       mode = "MACRORECORD";
       //flush out the old macro array
       for (int i =0;i<macroArrayLength;i++)
       {
       macro [i] = "";
       }
       //start record the macro
       Serial.println ("In processScreen. Starting Macro Record");
       myGLCD.print ("Press Macro Button required       ",10,380);
       delay(1500);
       do
       {
       getKey();  //get a macro number
       if (keyNum  < 5)
       {
       currentMacro = keyNum;  //the macro number being recorded
       Serial.print ("In processScreen Macro button is - ");
       Serial.println (keyNum);
       myGLCD.print ("Macro Button is now      ",10,380);
       String tempString = lbl[keyNum];
       tempString.remove(0,3);
       myGLCD.print (tempString, 180,380);
       delay (1500);
       //start recording macro array
       } 
       }
       while (keyNum == 99);
       
       }
       }
       */
      //****************************
      //*   ANY OTHER BUTTON       *
      //****************************
      if (!labelString.startsWith("/"))//any other button
      { 

        if (mode == "MACRORECORD")
        { //record Macro IR sequence
          /*
          Serial.print("Macro Counter is:");
           Serial.println (macroCounter);
           Serial.print("In processScreen. Macro to record is: ");
           Serial.print(deviceIndex);
           Serial.print ("- ");
           Serial.print(screenIndex);
           Serial.print ("- ");
           Serial.println(keyNum);
           
           String macroLine,str, strDI, strSI,strBtn, strBtnXX;  
           strDI += deviceIndex;
           strSI += screenIndex;
           strBtn += keyNum;
           int btnLength = strBtn.length();
           if ( btnLength ==1)//convert to 2 character string allows buttons up to 99
           {
           strBtnXX = "0";
           strBtnXX.concat(strBtn);
           strBtn = strBtnXX;
           }
           macroLine="";
           macroLine.concat (strDI);
           macroLine.concat ("-");
           macroLine.concat (strSI);
           macroLine.concat ("-");
           macroLine.concat (strBtn);
           macroLine.concat (".TXT");
           //macroLine.concat (".txt");
           macro[macroCounter] = macroLine;
           Serial.print("In processScreen. Macro Line is: ");
           Serial.println (macro[macroCounter]);
           if (macroCounter >= macroArrayLength)
           {
           myGLCD.print ("Macro is Full.          ",10,380);
           Serial.print("In processScreen. Maximum Macro Elements Reached: ");
           
           }
           else
           {
           macroCounter++;
           }
           */
        }  


        else //Send the IR only Key
        {

          if ( deviceIndex == oldDeviceIndex and screenIndex == oldScreenIndex and keyNum == oldKeyNum)
          { //same IR signal
            //Serial.println ("In processScreen.  Calling transmitIR");
            //printPulses();//display pulse data
            if (screenIndex == 9) //IR test  always get the file in case adjustments are being made to parameters
            {
              readPulseData (deviceIndex, screenIndex, keyNum);
            }
            transmitIr();
            //Serial.println ("In processScreen.  Returned from transmitIR");
          }
          else
          {//Get the new one
            Serial.println ("In processScreen.  Calling readPulseData");
            readPulseData (deviceIndex, screenIndex, keyNum);
            //printPulses(); //display the pulse data
            transmitIr();
            oldDeviceIndex = deviceIndex;
            oldScreenIndex = screenIndex;
            oldKeyNum = keyNum;
            //Serial.println ("In processScreen.  Returned from transmitIR");

          } 

        }
      }

    }//end if keyNum <99
  }//end do  
  while (keyNum <=99);//loop until
}
//*********************************************************************************
void monitorIr()
{
  int currentPulse = 0;
  unsigned long startTime = millis();
  myGLCD.setColor(textColor);
  //flush out the data array
  for (int i = 0;i<pulseSamples;i++)
  {
    pulses[i ][1] = 0 ;
    pulses[i ][0]= 0;
  }
  Serial.println ("In monitorIR. Waiting for IR signal");
  pinMode(8, INPUT); //IR receiver


  do
  {

    //while (PH5 && B00100000 == 1)//pin High  should work but is inconsistent
    while (digitalRead(8) ==1) 
    {
      if (millis() - startTime >irTimeOut)//introduce same code delay as for low pulses
      {
      }
    }
    pulses[currentPulse][1] = micros();//highPulse ;//save pulse
    //while( PH5 && B00100000 ==0 )//not high  should work but is inconsistent
    while (digitalRead(8) ==0)
    {
      if (millis() - startTime >irTimeOut)
      {
        Serial.println ("In monitorIR. Time Out");
        myGLCD.print ("**** IR Time out ****                ",10,380);
        delay (500);
        currentPulse = pulseSamples ;
        break;
      }
    }
    pulses[currentPulse][0] = micros();//lowPulse  //save pulse/
    currentPulse++;
  } 
  while (currentPulse <pulseSamples);
  //printPulses();
  Serial.println ("In monitorIR. Received IR signal");
  for ( int i = 0; i <pulseSamples-1 ; i++) //calculate the differences
  {
    pulses[i ][1] = pulses[i+1][1]-pulses[i][0] ;
    pulses[i ][0]= pulses[i+1][0]-pulses[i+1 ][1];
    //   pulses[i ][1] = pulses[i][0]-pulses[i][1] ;
    //   pulses[i ][0]= pulses[i+1][1]-pulses[i ][0];
    //check if too large
    if (pulses[i][1] >200000)
    {
      pulses[i][1] = 0;
    }
    if (pulses[i][0] >200000)
    {
      pulses[i][0] = 0;
    }

  }

  //discard last pair
  pulses[pulseSamples -1][0] = 0;
  pulses[pulseSamples -1][1] = 0;
  printPulses();
}

//**************************************************************************************
void readPulseData (int dI, int sI, int btn)//reads the pulse data file
{
  //SD.begin(53);
  //Serial.println( "In readPulseData. Entered Function");
  //Serial.print( "In readPulseData. Received Arguments dI,sI,btn  ");

  //Serial.print ( dI);
  //Serial.print(" , ");
  //Serial.print ( sI);
  //Serial.print(" , ");
  //Serial.println ( btn);


  int tmpCtr =0;
  // int loWord,hiWord =0;
  //byte loByte, hiByte;
  String fileName;   
  char charFileName[13];


  String str, strDI, strSI,strBtn, strDIXX, strSIXX,strBtnXX;  
  //int initCounter = 0;
  int packetCounter = 0;
  String packetData0;
  String packetData1;
  //String packetData2;
  //String packetData3;


  strDI += dI;
  strSI += sI;
  strBtn += btn;


  //Serial.println ("In readPulseData. Completed Declarations");
  //*********
  int DILength = strDI.length();
  if ( DILength ==1)//convert to 2 character string allows devices up to 99
  {
    strDIXX = "0";
    strDIXX.concat(strDI);
    strDI = strDIXX;
  }

  int SILength = strSI.length();
  if ( SILength ==1)//convert to 2 character string allow screens up to 99
  {
    strSIXX = "0";
    strSIXX.concat(strSI);
    strSI = strSIXX;
  }


  int btnLength = strBtn.length();
  if ( btnLength ==1)//convert to 2 character string allows buttons up to 99
  {
    strBtnXX = "0";
    strBtnXX.concat(strBtn);
    strBtn = strBtnXX;
  }

  fileName.concat (strDI);
  fileName.concat ("-");
  fileName.concat (strSI);
  fileName.concat ("-");
  fileName.concat (strBtn);
  fileName.concat (".TXT");

  //Serial.print("In readPulseData. String fileName is... ");
  //Serial.println(fileName);

  fileName.toCharArray(charFileName,13); //passing the value of the string to the character array


  //fileName.toCharArray(charFileName,15);
  //char charFileName = char (fileName);
  Serial.print("In readPulseData. Char Filename is.... ");  //display that fileName
  Serial.println(charFileName);
  //return;
  if (fileName == "")
  {
    Serial.println ("In readPulseData.   Problem with fileName");
    return;
  }
  char a;
  tmpCtr =0;
  //myFile = SD.open("Init.txt");
  myFile = SD.open(charFileName);
  if (myFile)
  {
    while (myFile.available()) 
    {
      a = (myFile.read());


      if (int(a) == 13 or int(a) == 10 or int(a) == 45)
      {

        if (int(a) == 10)  //Line Feed - end of line - use accumulated string
        {
          //Serial.println ("Reading File  ");  
          //Serial.println (str);
          //if (initCounter <3)
          //{//discard these three
          //}
          //else //accumulate 4 records
          //{
          if (packetCounter ==0)
          {
            packetData0= str;
            //Serial.print ("In readPulseData. packetData0 is..");
            //Serial.println (packetData0);
          }
          if (packetCounter ==1)
          {
            packetData1= str;
            //Serial.print ("In readPulseData. packetData1 is..");
            // Serial.println (packetData1);
          }
          // packetData[packetCounter] = str;
          packetCounter++;
          if (packetCounter == 2)
          {
            packetCounter = 0;
            //Serial.print ("In readPacketData. tmpCtr is: ");
            //Serial.println(tmpCtr);

            //process packets
            pulses [tmpCtr][0] = (adjustPauseDuration *(packetData0.toInt()))/100  ;
            pulses [tmpCtr][1] = (adjustPulseDuration *(packetData1.toInt()))/100 ;
            if (roundUp)
            {
              //450 to 750  =600
              if (pulses[tmpCtr][0]<=750 and pulses[tmpCtr][0]>=450)
              {
                pulses[tmpCtr][0]=600;
              }
              if (pulses[tmpCtr][1]<=750 and pulses[tmpCtr][1]>=450)
              {
                pulses[tmpCtr][1]=600;
              }
              //1350 to 1050 = 1200
              if (pulses[tmpCtr][0]<=1350 and pulses[tmpCtr][0]>=1050)
              {
                pulses[tmpCtr][0]=1200;
              }
              if (pulses[tmpCtr][1]<=1350 and pulses[tmpCtr][1]>=1050)
              {
                pulses[tmpCtr][1]=1200;
              }
              //2250 to 2550 = 2400
              if (pulses[tmpCtr][0]<=2550 and pulses[tmpCtr][0]>=2250)
              {
                pulses[tmpCtr][0]=2400;
              }
              if (pulses[tmpCtr][1]<=2550 and pulses[tmpCtr][1]>=2250)
              {
                pulses[tmpCtr][1]=2400;
              }
            }
            tmpCtr++;
            if (tmpCtr >=pulseSamples -1)
            {
              tmpCtr = pulseSamples -1;
            }
          }

          //}
          //initCounter ++;      
          str="";  //reset the string to ""
        }
      }
      else // accumulate the string
      {
        str.concat(a);
        //str = str + a;

      }

    }
    myFile.close();
    //Serial.println("In readPulseData. File Closed");    
  }
  else
  {
    Serial.println("In readPulseData.  File not Found");    
    //Flush out all old IR data
    for (int i = 0; i < pulseSamples;i++)
    {
      pulses [i][1] = 0;
      pulses [i][0] = 0;
    }
  }
  //Serial.println("In readPulseData. Exiting function");    
  // Serial.println();
}
//***************************************************
void writePulseData(int dI,int sI,int btn )//
//            writePulseData (deviceIndex,screenIndex,buttonIndex.button label array);
{
  // int temp;
  //int loWord,hiWord;
  // byte loByte, hiByte;

  //String labelBtn = "Power";
  char fileName[13];   //declaring character array
  String str, strdI, strsI,strbtn;  //declaring string
  //convert dI to 2 character string
  strdI = String (dI);
  int dILength;
  dILength = strdI.length();
  if ( dILength ==1)
  {
    strdI = "0" + strdI;
  }
  //convert sI to 2 character string
  strsI = String (sI);
  int sILength;
  sILength = strsI.length();
  if ( sILength ==1)
  {
    strsI = "0" + strsI;
  }
  //convert btn to 2 character string
  strbtn = String (btn);
  int btnLength;
  btnLength = strbtn.length();
  if ( btnLength ==1)
  {
    strbtn = "0" + strbtn;
  }


  str=strdI + "-" + strsI + "-" + strbtn + ".TXT" ; //converting integer into a string
  //str=String(dI) + "-" + String (sI) + "-" + strbtn + ".txt" ; //converting integer into a string

  str.toCharArray(fileName,13); //passing the value of the string to the character array
  Serial.print("In writePulseData.  Filename is.... \t");  //display that value
  Serial.println(fileName);

  // delete the old file:
  Serial.print("In writePulseData.  Removing old file... ");
  Serial.println(fileName);

  if (SD.exists(fileName))
  {
    SD.remove(fileName);
    delay(10);
  }
  if (SD.exists(fileName))
  { 
    Serial.print("In writePulseData.  Old file... ");
    Serial.print(fileName);
    Serial.println(" still exists. Must exit Function");
    return; //can't write new if old exists
  }
  else 
  {
    Serial.print("In writePulseData.  Old file... ");
    Serial.print(fileName);
    Serial.println(" does not exist or has been removed.");
  }

  //open for writing
  myFile = SD.open(fileName, FILE_WRITE);//fileName

  // if the file opened okay, write to it:
  if (myFile)  {
    //myFile.print (fileName);

    Serial.println("In writePulseData. Opened OK. Writing new file: ");
    //Device, Screen level, button
    //myFile.close();
    //return;
    // myFile.println(labelDevice[dI]);
    Serial.print("Device: ");//Device
    //Serial.println(labelDevice[dI]);//Device
    Serial.println(dI);//Device

    //myFile.println(sI);
    Serial.print("Screen Index: ");//
    Serial.println(sI);//Screen

    //myFile.println(labelBtn);
    //Serial.print("Button label: ");//
    //Serial.println(labelBtn);//Button



    //then the pulse data
    for (int i =0; i < pulseSamples; i++)//pulseSamples
    {
      myFile.println(pulses [i][0]);
      myFile.println(pulses [i][1]);
    }

    // close the file:
    myFile.close();
    Serial.print("In writePulseData.  SUCCESS.  Correctly finished writing new data file... ");
    Serial.println(fileName);
    myGLCD.print ("Success - Pulse data written to file. ",10,380);
    delay (150);
    //printPulses();
    Serial.println(" ");

  } 
  else {
    // if the file didn't open, print an error:
    Serial.print("In writePulseData. Did not write Data. Error opening file: ");
    Serial.println(fileName);
    myGLCD.print ("Error -Failed to write IR File  ",10,380);
    delay(500);
  }

}

//***************************************************
void printPulses(void) {
  Serial.println ("");
  Serial.println ("Printing Pulse IR - Delay usecs pairs");

  for (int i = 0; i < pulseSamples; i++) {
    //Serial.print("\t"); // tab
    Serial.print (i);
    Serial.print (" - ");
    Serial.print("pulseIR(1)(");
    Serial.print(pulses[i][1]  , DEC); //* RESOLUTION
    Serial.print(");");
    //Serial.print("");
    Serial.print("\t");
    Serial.print("delay us(0)(");
    Serial.print(pulses[i ][0] , DEC); //* RESOLUTION 
    Serial.println(");");

  }

}
//*************************************************

void drawMenu(int leftX, int topY, int cols, int rows, int width, int height, int colGap,int rowGap , char* lbl[],uint8_t* typeFace)
{

  //myGLCD.clrScr();
  //myGLCD.fillScr(screenBackColor);
  myGLCD.setBackColor(backColor);//(0, 0, 255);

  myGLCD.setFont(typeFace);
  int counter =0;

  for (int z= 0;z<32; z++)//erase old values of frame array
  {
    for (int y = 0; y<4;y++)
    {
      frame[z][y] =0;
    }
  }
  //return;//OK
  for (int y = 0 ;y<rows; y++)//do rows second
  {
    for (int x=0; x<cols; x++)//do columns first
    {
      //Set up the wait for it routine to draw the border
      int x1 = leftX +(x*width)+ (x *colGap);    
      int y1 = topY + (y *height) +(y * rowGap);
      int x2 = leftX +((x+1) *width)+ (x *colGap);     
      int y2 = topY + ((y+1) *height) +(y * rowGap);
      frame[counter][0] =x1;
      frame[counter][1] =y1;
      frame[counter][2] =x2;
      frame[counter][3] =y2;

      counter++;
      //drawFrame(int x1, int y1, int x2, int y2)

      //myGLCD.setColor(250, 255, 12);
      myGLCD.setColor(backColor);
      myGLCD.fillRoundRect (x1, y1, x2, y2);

      //myGLCD.setColor(255, 255, 255);//white
      myGLCD.setColor(frameColor);//white
      myGLCD.drawRoundRect (x1, y1, x2, y2);

      //myGLCD.setColor(VGA_BLACK);//white
      myGLCD.setColor(textColor);

      //char* labelText = lbl[counter-1];
      //following code converts the char from the label array to string and checks whther the 
      //first character is a "/" meaning an command or sub menu
      //and then parses out the commande from the true text to display

      String labelText(lbl[counter-1]); //converts char array to string
      // "/S2Colour" is the example
      String labelFinal = "";
      if (labelText.startsWith("/", 0)) //is a command not an IR code to send
      {
        labelFinal = labelText.substring (4); //parses out the right hand side 
      }
      else
      {
        labelFinal = labelText; 
      }
      myGLCD.print(labelFinal, 5 + x1 , 10 + y1); //display the label only
    }
  }  
  myGLCD.setColor(textColor);
}


//****************************************************

void getKey()
{
  int x;
  int y;
  keyNum =99;
  if (myTouch.dataAvailable())
  {
    for (int i = 0 ;i <5; i++)
    {
      myTouch.read();  //get a number of samples
    }
    //this is where you must calibrate the TFT touch screen to correspond to the screen button x,y
    /*For Landscape
     y = myTouch.getX() ;
     y = map(y,0,320,240,0);
     //Serial.print ("Y");
     //Serial.println (y);
     x = myTouch.getY();
     x= map(x,0,240,0,400);
     //Serial.print ("X");
     //Serial.println (x);
     */
    //For Portrait
    x = myTouch.getX() ;
    if (x <0 )
    {
      x =0;
    }
    x = map(x,295,0,0,220);//change this for different screens
    //Serial.print ("X");
    //Serial.println (x);
    y = myTouch.getY();
    if (y <0 )
    {
      y=0;
    }
    y= map(y,235,0,0,390);//change this for different screens
    //Serial.print ("Y");
    //Serial.println (y);
    //myGLCD.print ("Adj X/Y", 10,180);
    //    myGLCD.print ("   ", 90,180);
    //    myGLCD.print (String(x), 90,180);
    //    myGLCD.print ("   ", 120,180);
    //    myGLCD.print (String(y), 120,180);

    //CHECK SCREEN AGAINST FRAME DATA
    for (int z = 0; z<32; z++)
    {
      if ((x > frame [z][0] && x <frame[z][2]) && (y > frame [z][1] && y <frame[z][3]))
      {
        //touch found
        drawFrame(frame [z][0],frame [z][1],frame [z][2],frame [z][3],z);    
        keyNum = z;
        //Serial.println();
        // 
        if (keyNum <99)
        {
          Serial.print("In getKey.  keyNum =: ");
          Serial.println (keyNum);
        }
        exit;
      }


    }
  }
  //Serial.print ("In getKey. keyNum is: ");
  //Serial.println (keyNum);
  if (keyNum == 99) //no key pressed
  {
    long timeDiffMs;
    timeDiffMs = millis() - oldTime;
    //Serial.print ("In getkey.  time diff is; ");
    //Serial.println (timeDiffMs);
    if (timeDiffMs > offTime  * 1000)//offTime is milliseconds
    {

      //if (mode == "NIL")
      //{
      //Serial.println ("In getKey.  Power timeout");
      //Serial.print ("Oldtime/millis ");
      //Serial.print (oldTime);
      //Serial.print ("-");
      //Serial.println (millis());


      //oldTime = millis();
      digitalWrite (10, HIGH);//Power down 
      delay (2000);
      oldTime = millis();
      //}
    }
  }
  else
  {
    //Serial.println ("In getKey.  Re-setting Old time to current ms");
    digitalWrite (10, LOW);//Power down re-set
    oldTime = millis();
  }

}
//*************************************************
// Draw a frame while a button is touched
void drawFrame(int x1, int y1, int x2, int y2,int btnIndex)
{
  //myGLCD.setColor(255, 0, 0);
  //Invert color
  //myGLCD.setColor(textColor);
  //myGLCD.fillRect(x1, y1, x2, y2);
  //original
  myGLCD.setColor(frameHighlightColor);
  myGLCD.drawRoundRect (x1, y1, x2, y2);


  //while (myTouch.dataAvailable() )
  //{  
  //myTouch.read();
  //}
  delay (50);
  //Now draw a frame when screen released
  //myGLCD.setColor(backColor);
  //myGLCD.fillRect(x1, y1, x2, y2);

  //original

  myGLCD.setColor(frameColor);
  myGLCD.drawRoundRect (x1, y1, x2, y2);
}



//*********************************************************
void readEepromInitFile()
{
  //Addresses
  int temp;
  int loWord,hiWord;
  byte loByte, hiByte;

  loByte = EEPROM.read(0);
  if (loByte == 99)
  {
    hiByte = EEPROM.read(1);
    loByte = EEPROM.read(2);
    textColor =  (hiByte *256) + loByte;

    hiByte = EEPROM.read(3);
    loByte = EEPROM.read(4);
    backColor =  (hiByte *256) + loByte;

    hiByte = EEPROM.read(5);
    loByte = EEPROM.read(6);
    frameColor =  (hiByte *256) + loByte;

    hiByte = EEPROM.read(7);
    loByte = EEPROM.read(8);
    frameHighlightColor =  (hiByte *256) + loByte;

    hiByte = EEPROM.read(9);
    loByte = EEPROM.read(10);
    screenBackColor =  (hiByte *256) + loByte;

    hiByte = EEPROM.read(11);
    loByte = EEPROM.read(12);
    dutyHigh =  (hiByte *256) + loByte;

    hiByte = EEPROM.read(13);
    loByte = EEPROM.read(14);
    dutyLow =  (hiByte *256) + loByte;

    hiByte = EEPROM.read(15);
    loByte = EEPROM.read(16);
    adjustModulationLength =  (hiByte *256) + loByte;

    hiByte = EEPROM.read(17);
    loByte = EEPROM.read(18);
    adjustPulseDuration =  (hiByte *256) + loByte;


    if (adjustPulseDuration <80)
    {
      adjustPulseDuration =100;
    }
    if (adjustPulseDuration >120)
    {
      adjustPulseDuration = 100;
    }

    roundUp = EEPROM.read(19);
    offTime = EEPROM.read(20);
    if (offTime <15)
    {
      offTime = 15;
    }
    if (offTime >180)
    {
      offTime = 180;
    }
    hiByte = EEPROM.read(21);
    loByte = EEPROM.read(22);
    irTimeOut =  (hiByte *256) + loByte;
    if (irTimeOut <1000)
    {
      irTimeOut = 1000;
    }
    if (irTimeOut >6000)
    {
      irTimeOut = 6000;
    }
    hiByte = EEPROM.read(23);
    loByte = EEPROM.read(24);
    adjustPauseDuration =  (hiByte *256) + loByte;
    if (adjustPauseDuration <80)
    {
      adjustPauseDuration =100;
    }
    if (adjustPauseDuration >120)
    {
      adjustPauseDuration = 100;
    }

    Serial.println ("In readEepromInitFile. Init Data OK - Data read");
  }
  else
  {
    Serial.println ("In readEepromInitFile. Init Data does not exist.");
  }
}
//*********************************************************
void writeEepromInitFile()
{
  //Addresses
  //textcolor 0
  //
  //
  //
  int temp;
  int loWord,hiWord;
  byte loByte, hiByte;

  EEPROM.write (0,99);
  hiByte = highByte(textColor) ;//high byte
  EEPROM.write (1,hiByte);
  loByte = lowByte(textColor) ;//low byte
  EEPROM.write (2,loByte);


  hiByte = highByte(backColor) ;//high byte
  EEPROM.write (3,hiByte);
  loByte = lowByte(backColor) ;//low byte
  EEPROM.write (4,loByte);

  hiByte = highByte(frameColor) ;//high byte
  EEPROM.write (5,hiByte);
  loByte = lowByte(frameColor) ;//low byte
  EEPROM.write (6,loByte);

  hiByte = highByte(frameHighlightColor) ;//high byte
  EEPROM.write (7,hiByte);
  loByte = lowByte(frameHighlightColor) ;//low byte
  EEPROM.write (8,loByte);

  hiByte = highByte(screenBackColor) ;//high byte
  EEPROM.write (9,hiByte);
  loByte = lowByte(screenBackColor) ;//low byte
  EEPROM.write (10,loByte);

  hiByte = highByte(dutyHigh) ;//high byte
  EEPROM.write (11,hiByte);
  loByte = lowByte(dutyHigh) ;//low byte
  EEPROM.write (12,loByte);

  hiByte = highByte(dutyLow) ;//high byte
  EEPROM.write (13,hiByte);
  loByte = lowByte(dutyLow) ;//low byte
  EEPROM.write (14,loByte);

  hiByte = highByte(adjustModulationLength) ;//high byte
  EEPROM.write (15,hiByte);
  loByte = lowByte(adjustModulationLength) ;//low byte
  EEPROM.write (16,loByte);

  hiByte = highByte(adjustPulseDuration) ;//high byte
  EEPROM.write (17,hiByte);
  loByte = lowByte(adjustPulseDuration) ;//low byte
  EEPROM.write (18,loByte);

  EEPROM.write (19, roundUp);
  EEPROM.write (20, offTime);//offTime seconds

  hiByte = highByte(irTimeOut) ;//high byte
  EEPROM.write (21,hiByte);
  loByte = lowByte(irTimeOut) ;//low byte
  EEPROM.write (22,loByte);

  hiByte = highByte(adjustPauseDuration) ;//high byte
  EEPROM.write (23,hiByte);
  loByte = lowByte(adjustPauseDuration) ;//low byte
  EEPROM.write (24,loByte);



  Serial.println ("In writeEepromInitFile. Data written");



}

//*********************************************************
void transmitIr ()
{
  //cli();
  //for (int z = 0 ; z < 5 ; z++)//send it many times
  //{
  //digitalWrite   (9, LOW);
  //delay (1000);

  for (int i = 0; i <pulseSamples;i++)
  {
    pulseIR(pulses[i][1] ); //IR on //*


    digitalWrite   (9, LOW); //IR Off
    if (pulses[i][0] <16383)
    {
      delayMicroseconds ( pulses[i][0]);// problem is that delay us is unsigned int max 65,535 with accurate delay limited to 16383
    }
    else
    {
      delay(pulses[i][0]/1000);
    }
  }
  //}
  digitalWrite   (9, LOW); //IR Off
  //sei();  
}
//**********************************************************
void pulseIR(long microsecs) // Creates approx 38kHz pulses
{
  while (microsecs >0)
  {
    digitalWrite (9,HIGH);//approx 6us High carrier
    delayMicroseconds (dutyHigh);  //Duty cycle high was 5
    digitalWrite (9,LOW);//approx 6us Low carrier
    delayMicroseconds(dutyLow);//duty cycle low was 9
    microsecs -= adjustModulationLength; //was 26

  }
}
//*********************************************************
void cardInfo()
{
  Serial.print("\nCard type: ");
  switch(card.type()) {
  case SD_CARD_TYPE_SD1:
    Serial.println("SD1");
    break;
  case SD_CARD_TYPE_SD2:
    Serial.println("SD2");
    break;
  case SD_CARD_TYPE_SDHC:
    Serial.println("SDHC");
    break;
  default:
    Serial.println("Unknown");
  }

  // Now we will try to open the 'volume'/'partition' - it should be FAT16 or FAT32
  if (!volume.init(card)) {
    Serial.println("Could not find FAT16/FAT32 partition.\nMake sure you've formatted the card");
    return;
  }


  // print the type and size of the first FAT-type volume
  uint32_t volumesize;
  Serial.print("\nVolume type is FAT");
  Serial.println(volume.fatType(), DEC);
  Serial.println();

  volumesize = volume.blocksPerCluster();    // clusters are collections of blocks
  volumesize *= volume.clusterCount();       // we'll have a lot of clusters
  volumesize *= 512;                            // SD card blocks are always 512 bytes
  Serial.print("Volume size (bytes): ");
  Serial.println(volumesize);
  Serial.print("Volume size (Kbytes): ");
  volumesize /= 1024;
  Serial.println(volumesize);
  Serial.print("Volume size (Mbytes): ");
  volumesize /= 1024;
  Serial.println(volumesize);


  Serial.println("\nFiles found on the card (name, date and size in bytes): ");
  root.openRoot(volume);

  // list all files in the card with date and size
  root.ls(LS_R | LS_DATE | LS_SIZE);
}
//**************************************************
void readWriteTest()
{
  myFile = SD.open("test.txt", FILE_WRITE);

  // if the file opened okay, write to it:
  if (myFile) {
    Serial.print("In readWriteTest. Writing to test.txt...");
    myFile.println("testing 1, 2, 3.");
    // close the file:
    myFile.close();
    Serial.println("done.");
  } 
  else {
    // if the file didn't open, print an error:
    Serial.println("In readWriteTest. error opening test.txt");
  }

  // re-open the file for reading:
  myFile = SD.open("test.txt");
  if (myFile) {
    Serial.println("test.txt:");

    // read from the file until there's nothing else in it:
    while (myFile.available()) {
      Serial.write(myFile.read());
    }
    // close the file:
    myFile.close();
  } 
  else {
    // if the file didn't open, print an error:
    Serial.println("In readWriteTest. error opening test.txt");
  }
}



//**************************************************
int freeRam () {
  extern int __heap_start, *__brkval; 
  int v; 
  return (int) &v - (__brkval == 0 ? (int) &__heap_start : (int) __brkval); 
}
//***************************************************

//*************************************************
void SDCardReadDetails()
{
  myGLCD.clrScr();
  //myGLCD.setColor(255, 255, 0);
  myGLCD.setFont(SmallFont);
  // Open serial communications and wait for port to open:
  //Serial.begin(9600);
  //while (!Serial) {
  //  ; // wait for serial port to connect. Needed for Leonardo only
  //}


  Serial.print("\nInitializing SD card...");
  myGLCD.print("Initializing SD card...", 0,0);
  // On the Ethernet Shield, CS is pin 4. It's set as an output by default.
  // Note that even if it's not used as the CS pin, the hardware SS pin 
  // (10 on most Arduino boards, 53 on the Mega) must be left as an output 
  // or the SD library functions will not work. 
  pinMode(53, OUTPUT);     // change this to 53 on a mega


  // we'll use the initialization code from the utility libraries
  // since we're just testing if the card is working!
  if (!card.init(SPI_HALF_SPEED, chipSelect)) {
    Serial.println("initialization failed. Things to check:");
    myGLCD.print("initialization failed. Things to check:", 0,10);
    Serial.println("* is a card is inserted?");
    Serial.println("* Is your wiring correct?");
    Serial.println("* did you change the chipSelect pin to match your shield or module?");
    return;
  } 
  else {
    myGLCD.print("Wiring is correct and a card is present.", 0,20);
    Serial.println("Wiring is correct and a card is present."); 
  }

  // print the type of card
  Serial.print("\nCard type: ");
  switch(card.type()) {
  case SD_CARD_TYPE_SD1:
    myGLCD.print("SD1",0,30);
    Serial.println("SD1");
    break;
  case SD_CARD_TYPE_SD2:
    myGLCD.print("SD2",0,30);
    Serial.println("SD2");
    break;
  case SD_CARD_TYPE_SDHC:
    myGLCD.print("SDHC",0,30);
    Serial.println("SDHC");
    break;
  default:
    myGLCD.print("Unknown",0,30);
    Serial.println("Unknown");
  }

  // Now we will try to open the 'volume'/'partition' - it should be FAT16 or FAT32
  if (!volume.init(card)) {
    Serial.println("Could not find FAT16/FAT32 partition.\nMake sure you've formatted the card");
    return;
  }


  // print the type and size of the first FAT-type volume
  uint32_t volumesize;
  Serial.print("\nVolume type is FAT");
  myGLCD.print("Volume type is FAT",0,40);
  Serial.println(volume.fatType(), DEC);
  myGLCD.printNumI(volume.fatType(),0,50);
  Serial.println();

  volumesize = volume.blocksPerCluster();    // clusters are collections of blocks
  volumesize *= volume.clusterCount();       // we'll have a lot of clusters
  volumesize *= 512;                            // SD card blocks are always 512 bytes
  Serial.print("Volume size (bytes): ");
  myGLCD.print("Volume size (bytes)",0,60);
  myGLCD.printNumI(volumesize,0,70);
  Serial.println(volumesize);

  Serial.print("Volume size (Kbytes): ");
  myGLCD.print("Volume size (Kbytes)",0,80);
  volumesize /= 1024;
  myGLCD.printNumI(volumesize,0,90);
  Serial.println(volumesize);

  Serial.print("Volume size (Mbytes): ");
  myGLCD.print("Volume size (Mbytes): ", 0,100);
  volumesize /= 1024;
  Serial.println(volumesize);
  myGLCD.printNumI(volumesize,0,110);
  //myGLCD.setColor(255, 0, 0);


  Serial.println("\nFiles found on the card (name, date and size in bytes): ");
  myGLCD.print("Files found on the card (name, date and size in bytes): ", 0,130);
  root.openRoot(volume);
  // list all files in the card with date and size
  root.ls(LS_R | LS_DATE | LS_SIZE);



  delay (10000);
  //drawButtons();
}
//************************************
void readMacroData()
{
  /*
  Serial.println( "In readMacroData. Entered Function");
   String fileName;   
   char charFileName[12];
   
   String strMacro ;
   strMacro += currentMacro;
   int macroLength = strMacro.length();
   if ( macroLength ==1)//convert to 2 character string allows buttons up to 99
   {
   String strTemp = "0";
   strTemp.concat(strMacro);
   strMacro = strTemp;
   }
   fileName = "Macro";
   fileName.concat (strMacro);
   fileName.concat (".TXT");
   
   Serial.print("In readMacroData. String fileName is... ");
   Serial.println(fileName);
   
   fileName.toCharArray(charFileName,12); //passing the value of the string to the character array
   Serial.print("In readMacroData. Char Filename is.... ");  //display that fileName
   Serial.println(charFileName);
   if (fileName == "")
   {
   Serial.println ("In readMacroData.   Problem with fileName");
   return;
   }
   char a;
   int tmpCtr =0;
   String str= "";
   
   //delay(10000);
   myFile = SD.open(charFileName);
   if (myFile)
   {
   while (myFile.available()) 
   {
   a = (myFile.read());
   
   if (int(a) == 13 or int(a) == 10 )//or int(a) == 45)
   {
   if (int(a) == 10)  //Line Feed - end of line - use accumulated string
   {
   Serial.print ("In readMacroData.  Reading File  ");  
   Serial.println (str);
   macro[tmpCtr]  = str;
   //delay (1000);
   
   tmpCtr ++;   
   if (tmpCtr >= macroArrayLength)
   {
   tmpCtr= macroArrayLength -1;
   }   
   str= "";  
   }
   
   }
   
   
   else // accumulate the string
   {        
   //Serial.print ("a is ");
   //Serial.print (a);
   
   str.concat(a);
   //Serial.print ("str is : ");
   //Serial.println (str);
   }
   }
   myFile.close();
   Serial.println("In readMacroData. File Closed");    
   }
   else
   {
   Serial.println("In readMacroData.  File not Found");    
   }
   Serial.println("In readMacroData. Exiting function");    
   Serial.println();
   */
}



//*********************************************************
void writeMacroFile()
{
  /*
  //Macro file file name format is Macroxx.txt where xx is the number of the macro 00 to 99.
   for (int i =0; i<macroArrayLength;i++)
   {
   Serial.print("In writeMacroFile.  Macro Line is: ");
   Serial.print (i);
   Serial.print (" is ");
   Serial.println (macro[i]);
   }
   macroCounter = 0;
   delay(1500);
   
   int temp;
   int loWord,hiWord;
   byte loByte, hiByte;
   char fileName[12];   //declaring character array
   String str, strMacro;  //declaring string
   strMacro = String (currentMacro);
   int macroLength;
   macroLength = strMacro.length();
   if ( macroLength ==1)
   {
   strMacro = "0" + strMacro;
   }
   //str=String(dI) + "-" + String (sI) + "-" + strbtn + ".txt" ; //converting integer into a string
   str= "Macro" + strMacro+ ".TXT";
   str.toCharArray(fileName,12); //passing the value of the string to the character array
   Serial.print("In writeMacroFile.  Filename is.... \t");  //display that value
   Serial.println(fileName);
   //return;
   
   
   // delete the old file:
   Serial.print("Removing old file... ");
   Serial.println(fileName);
   SD.remove(fileName);
   if (SD.exists(fileName))
   { 
   Serial.print("Old file... ");
   Serial.print(fileName);
   Serial.println(" still exists.");
   }
   else 
   {
   Serial.print("Old file... ");
   Serial.print(fileName);
   Serial.println(" has been removed.");
   }
   
   //open for writing
   myFile = SD.open(fileName, FILE_WRITE);
   
   // if the file opened okay, write to it:
   if (myFile) 
   {
   Serial.println("In writeMacroFile.  Writing new file: ");
   //Device, Screen level, button
   //Serial.print("Device: ");//Device
   //Serial.println(labelDevice[dI]);//Device
   //myFile.println(labelDevice[dI]);
   
   //Serial.print("Screen Index: ");//
   //Serial.println(sI);//Screen
   //myFile.println(sI);
   
   //Serial.print("Button label: ");//
   //Serial.println(labelBtn);//Button
   //myFile.println(labelBtn);
   
   
   //then the macro data
   for (int i =0; i < macroArrayLength; i++)
   {
   myFile.println(macro[i]);
   //loByte = lowByte(pulses [i][1]) ;//low byte
   //myFile.println(loByte);
   
   //hiByte = highByte(pulses[i][1]) ;//high byte
   //myFile.println(hiByte);
   
   //loByte = lowByte(pulses [i][0]) ;//low byte
   //myFile.println(loByte);
   
   //hiByte = highByte(pulses [i][0]) ;//high byte
   //myFile.println(hiByte);
   }
   // close the file:
   myFile.close();
   Serial.print("In writeMacroFile.  Finished writing new file... ");
   Serial.println(fileName);
   Serial.println(" ");
   
   } 
   else {
   // if the file didn't open, print an error:
   Serial.println("In writeMacroFile.  Error opening ");
   Serial.println(fileName);
   }
   */
}
//**************************************
// changes the selected device 
void selectDevice(String labelString)
{
  Serial.println();
  Serial.println    ("In selectDevice.  Yes starts with /D");  
  Serial.print("In selectDevice.  labelString = ");
  Serial.println(labelString);

  //work out the Device where "/Dx" where x is the device number
  //isolate the x
  //String subMenuString;
  //labelString = String(lbl[keyNum]); //converts char array to string

    String subDeviceString = (labelString.substring (2,4)); //substring (start index, end index) base is zero
  Serial.print("In selectDevice.  subDeviceString = ");
  Serial.println(subDeviceString);

  deviceIndex = subDeviceString.toInt(); //String to Int
  Serial.print("In selectDevice.  Device number = ");
  Serial.println(deviceIndex);
  myGLCD.setColor(textColor);
  myGLCD.print ( "                                    ", 10,380);
  myGLCD.print ("Device selected is:", 10,380);
  //myGLCD.print (String (deviceIndex), 175,380);
  myGLCD.print (labelDevice[deviceIndex], 175,380);
  //myGLCD.print (lbl[deviceIndex], 175,380);

}

//**********************************************
//runs when the program btn is pressed and exits when btn pressed to finish prog
void programBtn(char* lbl[],int progBtn)
{
  myGLCD.setColor(textColor);
  if (mode == "MACRORECORD")//don't use prg when in macrorecord
  {
    return;
  }
  Serial.println ();
  Serial.println ("In programBtn.  Programme button pressed - Starting pgm..");

  do
  {
    myGLCD.print ("Press a button.  Prog to end       ", 10,380);

    getKey();
    if (keyNum <99 and keyNum != progBtn)
    {
      String labelString = String(lbl[keyNum]);
      Serial.print ("In programBtn. label is ");
      Serial.println (labelString);

      if (labelString.startsWith("/")) //other functions
      {
        //Do nothing
      }
      else
      { //normal IR button
        myGLCD.setColor(textColor);
        myGLCD.print ("You pressed button                  ", 10,380);
        myGLCD.print (lbl[keyNum], 180,380);
        delay(250);
        myGLCD.print ("Press the IRemote button            ",10,380);
        //delay(3000);
        monitorIr();
        myGLCD.print ("IRemote button recorded             ",10,380);
        delay(250);
        //now save the buton
        //writePulseData ("0-1-0.txt",0);
        //char* labelbtn1 = lbl[keyNum];
        //******************************************
        writePulseData (deviceIndex,screenIndex,keyNum);//,labelbtn1
        //printPulses();
        //myGLCD.print ("Press another or Prog to end",10,380);        
        //delay(2000);
      }      
    }

  } //end do
  while (keyNum != progBtn);

  if ( keyNum == progBtn)
  {                 
    mode = "NIL";
    Serial.println ("In programBtn.  Prog button pressed - Finishing pgm.."); 
    // myGLCD.print ("                          ", 10,380);
    myGLCD.setColor(textColor);
    myGLCD.print ( "                                    ", 10,380);
    myGLCD.print   ("Device selected is: ", 10,380);
    myGLCD.print (labelDevice[deviceIndex], 175,380);
    //myGLCD.print (lbl[deviceIndex], 175,380);

    delay(500); //to prevent repeat presses
  }//if keynum == pgmBtn
  else
  {
  }
}
//**********************************************
//***************************************************
void printColorPallette()
{
  Serial.println ("VGA_WHITE");
  Serial.println (VGA_WHITE);
  Serial.println ("VGA_BLACK");
  Serial.println (VGA_BLACK);
  Serial.println ("VGA_RED");
  Serial.println (VGA_RED);
  Serial.println ("VGA_BLUE");
  Serial.println (VGA_BLUE);
  Serial.println ("VGA_GREEN");
  Serial.println (VGA_GREEN);
  Serial.println ("VGA_LIME");
  Serial.println (VGA_LIME);
  Serial.println ("VGA_YELLOW");
  Serial.println (VGA_YELLOW);
  Serial.println ("VGA_AQUA");
  Serial.println (VGA_AQUA);
}
//*************************************************

//**********************************************************

//*************************************************************
void selectColors()
{
  drawMenu(5, 205, 3, 4, 70, 40,5,5, menuData,SmallFont);  // draw the buttons
  myGLCD.setColor(255,0,0); //draw the red slider
  myGLCD.fillRect(5, 5, 235, 30);
  myGLCD.setColor(0,255,0); //draw the green sloder
  myGLCD.fillRect(5, 35, 235, 60);
  myGLCD.setColor(0,0,255);//draw the blue slider
  myGLCD.fillRect(5, 65, 235, 90);
  static int colorChange = 1;
  int x =0;
  int y =0;
  int rColor =0;
  int gColor =0;
  int bColor= 0;

  long rgbColor;
  do
  {
    //colorChange = 0;
    getKey();
    // Serial.print("keyNum- ");
    // Serial.println (keyNum);
    // Serial.print("colorChange- ");
    // Serial.println (colorChange);

    if (keyNum <12)
    {
      colorChange = 1;
      //Serial.println ("Keynum < 12");
    }

    if (keyNum == 0)
    {
      rColor = rColor +5;
      //colorChange = 1;
      if (rColor >255)
      {
        rColor = 0;

      }
    }
    if (keyNum ==3)
    {
      rColor = rColor -5;
      if (rColor <0)
      {
        rColor = 255;
      }
    }
    if (keyNum ==1)
    {
      gColor = gColor +5;
      if (gColor >255)
      {
        gColor = 0;
      }

    }
    if (keyNum ==4)
    {
      gColor = gColor -5;
      if (gColor <0)
      {
        gColor = 255;
      }

    }
    if (keyNum ==2)
    {
      bColor = bColor +5;
      if (bColor >255)
      {
        bColor = 0;
      }
    }

    if (keyNum ==5)
    {
      bColor = bColor -5;
      if (bColor <0)
      {
        bColor = 255;
      }
    }
    if (keyNum ==6) //screenBackColor
    {
      screenBackColor = rgbColor;
    }
    if (keyNum ==7) //BackGround
    {
      backColor = rgbColor;
    }
    if (keyNum ==8) //Text
    {
      textColor = rgbColor;
    }
    if (keyNum ==9) //TBorder
    {
      frameColor = rgbColor;
    }
    if (keyNum ==10) //frameHighlight
    {
      frameHighlightColor = rgbColor;
    }
    if (keyNum == 11) //Exit
    {
      screenIndex =7;
      writeEepromInitFile();
      return;
    }
    x= 0;
    y =0;
    if (myTouch.dataAvailable())
    {
      //for (int i = 0 ;i <5; i++)
      //{
      myTouch.read();  //get a number of samples
      //Serial.println ("Reading Touch");
      //}
      /* old touch for landscape
       y = myTouch.getX() ;
       y = map(y,0,320,240,0);
       x = myTouch.getY();
       x= map(x,0,240,0,400);
       Landscape
       */
      //For Portrait
      x = myTouch.getX() ;
      x = map(x,300,0,0,220);
      //Serial.print ("X");
      //Serial.println (x);
      y = myTouch.getY();
      y= map(y,240,0,0,400);
      //Serial.print ("Y");
      //Serial.println (y);

    }
    //Serial.print ("After mytouch - ColorChange = ");
    //Serial.println (colorChange);

    if (x> 5 and x<235)
    { 
      if (y >5 and y <30)//Red
      {
        rColor = x;
        colorChange = 1;

      }
      if (y >35 and y <60)//Green
      {
        gColor = x;
        colorChange = 1;
      }
      if (y >65 and y <90)//Blue
      {  
        bColor = x;
        colorChange =1;
      }
    }
    //Serial.print("colorChange - ");
    //Serial.println (colorChange);
    if (colorChange == 1)
    {
      drawMenu(5, 205, 3, 4, 70, 40,5,5,menuData,SmallFont);  // draw the buttons
      colorChange = 0;
      //myGLCD.fillScr(screenBackColor);
      //Serial.println ("Updating display");
      //Serial.print("colorChange - ");
      //Serial.println (colorChange);
      //drawMenu(5, 100, 6, 2, 60, 40,5,labelColors);
      //Draw line in Red Box
      myGLCD.setColor(255,0,0);
      myGLCD.fillRect(5, 5, 235, 30);
      myGLCD.setColor(VGA_BLACK);
      myGLCD.fillRect(rColor,5,rColor +2,30);

      //Draw line in Green
      myGLCD.setColor(0,255,0);
      myGLCD.fillRect(5, 35, 235, 60);
      myGLCD.setColor(VGA_BLACK);
      myGLCD.fillRect(gColor,35,gColor +2,60);

      //Draw line in B
      myGLCD.setColor(0,0,255);
      myGLCD.fillRect(5, 65, 235, 90);
      myGLCD.setColor(VGA_BLACK);
      myGLCD.fillRect(bColor,65,bColor +2,90);


      //Draw Sample Background Box
      myGLCD.setColor(rColor,gColor,bColor);
      //myGLCD.setColor(VGA_YELLOW);
      myGLCD.fillRect(5, 100, 235, 140);



      //255, 255, 0);


      myGLCD.setBackColor(backColor);
      myGLCD.print("     ",10,180);
      myGLCD.setColor(textColor);
      myGLCD.printNumI(rColor,10,180);

      myGLCD.setBackColor(backColor);
      myGLCD.print("      ",90,180);
      myGLCD.setColor(textColor);
      myGLCD.printNumI(gColor,90,180);

      myGLCD.setBackColor(backColor);
      myGLCD.print("      ",160,180);
      myGLCD.setColor(textColor);
      myGLCD.printNumI(bColor,160,180);


      myGLCD.setBackColor(backColor);
      //myGLCD.print("       ",300,220);
      myGLCD.setColor(textColor);
      rgbColor = RGB565CONVERT(rColor,gColor,bColor);
      //myGLCD.printNumI(rgbColor,300,220);

      //colorChange = 0;

    }
  }
  while ( (keyNum != 11));
}
//*************************************************
//unsigned int RGB565CONVERT(int r,int g,int b,const char* color) {
unsigned int RGB565CONVERT(int r,int g,int b) {
  long RGB565;

  RGB565=(((r&0xF8)<<8)|((g&0xFC)<<3)|((b&0xF8)>>3));
  //pc.printf("#define  %s      0x%0.4X\n",color,RGB565);
  return RGB565;
}

//*****************************************************





















